%define rname lxc

Name: pve-%rname
Version: 4.0.3
Release: alt1
Summary: Linux containers usersapce tools
Group: System/Configuration/Other
License: LGPL
URL: https://linuxcontainers.org/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

ExclusiveArch: x86_64 aarch64
Requires: lxcfs
Conflicts: %rname %rname-libs

Source: %rname-%version.tar.gz
Source1: %rname-config.tar

Patch1: 0001-allow-running-lxc-monitord-as-a-system-daemon.patch
Patch2: 0002-systemd-Add-Documentation-key.patch
Patch3: 0003-introduce-lxc.cgroup.dir.-monitor-container-containe.patch
Patch4: 0004-doc-s-lxc.cgroup.container.namespace-lxc.cgroup.cont.patch
Patch5: 0005-confile-coding-style-fixes-for-set_config_cgroup_con.patch
Patch6: 0006-api-extensions-add-and-document-cgroup_advanced_isol.patch
Patch7: 0007-doc-Add-lxc.cgroup.dir.-monitor-container-container..patch
Patch8: 0008-confile-fix-jump-table-order.patch
Patch9: 0009-get-the-right-path-in-get_cgroup-command.patch
Patch10: 0010-cgroups-adhere-to-boolean-return.patch
Patch11: 0011-PVE-Config-lxc.service-start-after-a-potential-syslo.patch
Patch12: 0012-PVE-Config-deny-rw-mounting-of-sys-and-proc.patch
Patch13: 0013-PVE-Config-attach-always-use-getent.patch
Patch14: 0014-apparmor-Allow-ro-remount-of-boot_id.patch

Patch20: lxc-alt.patch
Patch21: lxc-altlinux-lxc.patch
Patch23: lxc-alt-remove-dependency-on-policycoreutils.patch

BuildRequires: docbook2X libcap-devel libdbus-devel libgnutls-devel libseccomp-devel libselinux-devel

%description
Containers provides resource management through control groups and
resource isolation through namespaces. The linux containers, lxc, aims
to use these new functionalities to provide an userspace container
object which provides full resource isolation and resource control for
an applications or a system.

%add_findreq_skiplist %_datadir/%rname/lxc-patch.py
%add_findreq_skiplist %_datadir/%rname/templates/*

%prep
%setup -q -n %rname-%version -a1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1

%patch20 -p1 -b .alt
%patch21 -p1 -b .altlinux
%patch23 -p1 -b .pol

%build
%autoreconf
%configure \
    --disable-static \
    --disable-rpath \
    --with-distro=altlinux \
    --with-init-script=systemd \
    --disable-apparmor \
    --enable-selinux \
    --enable-bash \
    --disable-examples \
    --enable-seccomp \
    --with-cgroup-pattern='lxc/%n' \
    --localstatedir=%_var

%make_build

%install
%make DESTDIR=%buildroot install

mkdir -p %buildroot%_datadir/lxc/config
for i in config/*.conf.in; do
	sed -e "s|@LXCTEMPLATECONFIG@|%_datadir/lxc/config|g" $i > %buildroot%_datadir/lxc/${i%.in};
done

rm -fr %buildroot/usr/lib/%rname/%rname-apparmor-load

%files
%config(noreplace) %_sysconfdir/sysconfig/%rname
%dir %_sysconfdir/%rname
%config(noreplace) %_sysconfdir/%rname/default.conf
#_sysconfdir/bash_completion.d/%rname
%systemd_unitdir/*.service
%_bindir/%rname-*
%_sbindir/init.%rname
/usr/lib/%rname
%_libdir/%rname
%_libdir/*.so.*
%_datadir/%rname
%_man1dir/*.1*
%_man5dir/*.5*
%_man7dir/*.7*

%changelog
