%define _unpackaged_files_terminate_build 1

%def_with check

Name: pylint
Version: 1.9.1
Release: alt2

Summary: Python code static checker
License: GPLv2+
Group: Development/Python
# https://github.com/PyCQA/pylint.git
Url: http://www.pylint.org/

Source: %name-%version.tar

BuildRequires: python-module-setuptools
BuildRequires: python-module-pytest-runner

%if_with check
BuildRequires: python-module-pytest
BuildRequires: python-module-astroid
BuildRequires: python-module-mccabe
BuildRequires: python-module-configparser
BuildRequires: python-module-isort
%endif

BuildArch: noarch
%py_requires mccabe

%description
Pylint is a Python source code analyzer which looks for programming
errors, helps enforcing a coding standard and sniffs for some code
smells (as defined in Martin Fowler's Refactoring book)

Pylint can be seen as another PyChecker since nearly all tests you
can do with PyChecker can also be done with Pylint. However, Pylint
offers some more features, like checking length of lines of code,
checking if variable names are well-formed according to your coding
standard, or checking if declared interfaces are truly implemented,
and much more.

Additionally, it is possible to write plugins to add your own checks.

%prep
%setup

%build
%python_build

%install

%python_install
# do not pack tests and hide from python.req
rm -r %buildroot%python_sitelibdir/%name/test*

%check
PYTHONPATH=$(pwd) py.test -v

%files
%doc ChangeLog README.rst doc/
%_bindir/pylint
%_bindir/epylint
%_bindir/pyreverse
%_bindir/symilar
%python_sitelibdir/%name
%python_sitelibdir/%name-%version-py2*.egg-info

%changelog
