%define _unpackaged_files_terminate_build 1
%define oname BTrees

%def_with check
%def_with bootstrap

Name: python-module-%oname
Version: 4.4.1
Release: alt3

Summary: Scalable persistent object containers
License: ZPLv2.1
Group: Development/Python
# https://github.com/zopefoundation/BTrees.git
Url: https://pypi.python.org/pypi/BTrees

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-module-objects.inv
BuildRequires: python-module-repoze.sphinx.autointerface
BuildRequires: python-module-persistent
BuildRequires: python-module-setuptools
%if_without bootstrap
BuildRequires: python-module-ZODB
%endif
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-persistent
%if_without bootstrap
BuildRequires: python3-module-ZODB
%endif

%if_with check
BuildRequires: python-module-tox
BuildRequires: python-module-virtualenv
BuildRequires: python-module-transaction
%if_without bootstrap
BuildRequires: python-module-ZODB-tests
%endif
BuildRequires: python3-module-tox
BuildRequires: python3-module-virtualenv
BuildRequires: python3-module-transaction
%if_without bootstrap
BuildRequires: python3-module-ZODB-tests
%endif
%endif

%py_requires zope.interface

%define overview							   \
BTrees: scalable persistent components.					   \
									   \
This package contains a set of persistent object containers built around   \
a modified BTree data structure. The trees are optimized for use inside    \
ZODB's "optimistic concurrency" paradigm, and include explicit		   \
resolution of conflicts detected by that mechannism.			   \
									   \
%nil

%description %overview
%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
This package contains documentation for %oname.

%package -n python3-module-%oname
Summary: Scalable persistent object containers
Group: Development/Python3

%description -n python3-module-%oname
%overview

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This package contains tests for %oname.

%prep
%setup

rm -rf ../python3
cp -a . ../python3

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python_build_debug

pushd ../python3
%python3_build_debug
popd

%install
%python_install

pushd ../python3
%python3_install
popd

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html

%check
export PIP_INDEX_URL=http://host.invalid./
export PYTHONPATH=%python_sitelibdir_noarch:%python_sitelibdir
TOX_TESTENV_PASSENV='PYTHONPATH' tox -e py%{python_version_nodots python} -v

pushd ../python3
export PYTHONPATH=%python3_sitelibdir_noarch:%python3_sitelibdir
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 -e py%{python_version_nodots python3} -v
popd

%files
%doc *.txt *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%files docs
%doc docs/_build/html/*

%files -n python3-module-%oname
%doc *.txt *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests

%changelog
