%define _unpackaged_files_terminate_build 1

%define oname GitPython

%def_with python3
%def_disable check

Name: python-module-%oname
Version: 2.1.10
Release: alt1
Summary: GitPython is a python library used to interact with Git repositories
License: BSD
BuildArch: noarch
Group: Development/Python
Url: http://pypi.python.org/pypi/GitPython/

# https://github.com/gitpython-developers/GitPython.git
Source: %name-%version.tar
Patch1: %oname-alt-build.patch

BuildRequires: python-module-setuptools python2.7(gitdb) python-module-ddt python-module-mock
BuildRequires: git-core
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3(gitdb) python3-module-ddt python3-module-mock
%endif

Requires: git-core

%description
A simple, flexible, easy-to-use configfile and command-line parsing library
built on top of the standard library optparse module.

%package -n python3-module-%oname
Summary: GitPython is a python library used to interact with Git repositories
Group: Development/Python3
Requires: git-core

%description -n python3-module-%oname
A simple, flexible, easy-to-use configfile and command-line parsing library
built on top of the standard library optparse module.

%prep
%setup
%patch1 -p1

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
# needed for tests
git config --global user.email "darktemplar at altlinux.org"
git config --global user.name "darktemplar"

rm -f .gitmodules

git init
git add -A
git commit -m "%version"
git tag %version -m "%version"

git tag 0.1.6 -m "0.1.6"

nosetests

%if_with python3
pushd ../python3

rm -f .gitmodules

git init
git add -A
git commit -m "%version"
git tag %version -m "%version"

git tag 0.1.6 -m "0.1.6"

nosetests3
popd
%endif

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/git/test

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/git/test
%endif

%changelog
