# -*- mode: rpm-spec; coding: utf-8 -*-
%define version 0.9.9
%define release    alt1.1
%define source_version 0.9.9
%define source_name Pyrex
%setup_python_module Pyrex

%add_python_req_skip Pyrex

Summary: A language for writing Python extension modules
Name: python-module-Pyrex
Version: %version
Release: %release
Source: %source_name-%source_version.tar
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
License: Freeware
Group: Development/Python
Prefix: %_prefix
Url: http://www.cosc.canterbury.ac.nz/~greg/python/Pyrex/
BuildPreReq: rpm-build-python
BuildArch: noarch

Requires: %name-pickles = %version-%release

%description
Pyrex  is  a  language  specially designed for writing Python extension
modules.  It's designed to bridge the gap between the nice, high-level,
easy-to-use world of Python and the messy, low-level world of C.

%package pickles
Summary: Pickle file for Pyrex
Group: Development/Python
BuildArch: noarch

%description pickles
Pyrex  is  a  language  specially designed for writing Python extension
modules.  It's designed to bridge the gap between the nice, high-level,
easy-to-use world of Python and the messy, low-level world of C.

This package contains pickle file for Pyrex.

%prep
%setup -q -n %source_name-%source_version

%build
%python_build

%install
CFLAGS="%optflags" python setup.py \
	install --optimize=2 \
		--root=%buildroot \
		--record=INSTALLED_FILES

# fool the ALT building system a little to avoid dependency on 
# python-strict :-)
subst 's/^#!.*\/python\([ 	].*\)\?$/#!\/usr\/bin\/env python%_python_version\1/' \
	%buildroot%_bindir/*

# Remove Mac-specific stuff
subst '/\/Mac\//d' INSTALLED_FILES
# Remove test file
subst '/\/Plex\/test/d' INSTALLED_FILES

%files -f INSTALLED_FILES
%doc README.txt ToDo.txt USAGE.txt CHANGES.txt Doc Demos
%dir %python_sitelibdir/Pyrex
%dir %python_sitelibdir/Pyrex/Compiler
%exclude %python_sitelibdir/Pyrex/Compiler/*.pickle
%dir %python_sitelibdir/Pyrex/Distutils
%dir %python_sitelibdir/Pyrex/DistutilsOld
%dir %python_sitelibdir/Pyrex/Plex
%dir %python_sitelibdir/Pyrex/Unix

%files pickles
%python_sitelibdir/Pyrex/Compiler/*.pickle

%changelog
