
%global modname alembic

%def_with python3

Name: python-module-alembic
Version: 1.0.5
Release: alt2

Summary: Database migration tool for SQLAlchemy

License: MIT
Group: Development/Python
Url: http://pypi.python.org/pypi/alembic

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://pypi.python.org/packages/source/a/%modname/%modname-%version.tar.gz

BuildArch: noarch

%py_provides alembic.migration alembic.environment

BuildRequires(pre): rpm-build-python

BuildRequires: help2man
BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-mako
BuildRequires: python-module-SQLAlchemy >= 0.9.0
BuildRequires: python-module-editor >= 0.3
BuildRequires: python-module-dateutil

BuildRequires: python-module-nose
BuildRequires: python-module-mock
BuildRequires: python-module-SQLAlchemy-tests
BuildRequires: python-module-pytest

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-mako python3-module-nose
BuildRequires: python3-module-SQLAlchemy python3-module-setuptools
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-pytest
%endif

%description
Alembic is a new database migrations tool, written by the author of
SQLAlchemy <http://www.sqlalchemy.org>.  A migrations tool offers the
following functionality:

* Can emit ALTER statements to a database in order to change the structure
of tables and other constructs.
* Provides a system whereby "migration scripts" may be constructed; each script
indicates a particular series of steps that can "upgrade" a target database to
a new version, and optionally a series of steps that can "downgrade"
similarly, doing the same steps in reverse.
* Allows the scripts to execute in some sequential manner.

Documentation and status of Alembic is at http://readthedocs.org/docs/alembic/

%package tests
Summary: Tests for %modname
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains tests for %modname.

%package -n python3-module-%modname
Summary: Database migration tool for SQLAlchemy
Group: Development/Python3
%py3_provides alembic.migration alembic.environment

%description -n python3-module-%modname
Alembic is a new database migrations tool, written by the author of
SQLAlchemy <http://www.sqlalchemy.org>.  A migrations tool offers the
following functionality:

* Can emit ALTER statements to a database in order to change the structure
of tables and other constructs.
* Provides a system whereby "migration scripts" may be constructed; each script
indicates a particular series of steps that can "upgrade" a target database to
a new version, and optionally a series of steps that can "downgrade"
similarly, doing the same steps in reverse.
* Allows the scripts to execute in some sequential manner.

Documentation and status of Alembic is at http://readthedocs.org/docs/alembic/

%package -n python3-module-%modname-tests
Summary: Tests for %modname
Group: Development/Python3
Requires: python3-module-%modname = %EVR

%description -n python3-module-%modname-tests
This package contains tests for %modname.

%prep
%setup -n %modname-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build

mkdir bin
echo 'python -c "import alembic.config; alembic.config.main()" $*' > bin/alembic
chmod 0755 bin/alembic
help2man --version-string %{version} --no-info -s 1 bin/alembic > alembic.1

%if_with python3
pushd ../python3
%python3_build
mkdir bin
echo 'python3 -c "import alembic.config; alembic.config.main()" $*' > bin/alembic
chmod 0755 bin/alembic
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i $i.py3
done
popd
%endif

%python_install
mkdir -p %buildroot%_man1dir/
install -m 0644 alembic.1 %buildroot%_man1dir/alembic.1

%check
python setup.py test

%files
%doc README.rst LICENSE CHANGES docs
%_bindir/%modname
%_man1dir/alembic.1*
%python_sitelibdir/*
%exclude %python_sitelibdir/*/testing

%files tests
%python_sitelibdir/*/testing

%if_with python3
%files -n python3-module-%modname
%doc README.rst LICENSE CHANGES docs
%_bindir/%modname.py3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/testing

%files -n python3-module-%modname-tests
%python3_sitelibdir/*/testing
%endif

%changelog
