%define module_name amqp

%def_with python3

Name: python-module-%module_name
Version: 2.3.2
Epoch: 1
Release: alt1
Group: Development/Python
License: GPLv2
Summary: fork of amqplib used by Kombu containing additional features and improvements
URL: http://github.com/celery/py-amqp.git

Source: %name-%version.tar

BuildRequires: python-module-setuptools
BuildRequires: python-module-alabaster python-module-html5lib python-module-objects.inv python-module-sphinxcontrib-issuetracker python2.7(sphinx_celery)
BuildRequires: python2.7(vine) python2.7(case)
BuildRequires: python-module-unittest2
BuildRequires: python-module-mock
BuildRequires: python-module-pytest-sugar >= 0.9.1
BuildRequires(pre): rpm-macros-sphinx
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-sugar >= 0.9.1
BuildRequires: python3(vine) python3(case)
%endif

%description
This is a fork of amqplib_ which was originally written by Barry Pederson.
It is maintained by the Celery_ project, and used by kombu as a pure python
alternative when librabbitmq is not available.

%package pickles
Summary: Pickles for %module_name
Group: Development/Python

%description pickles
This is a fork of amqplib_ which was originally written by Barry Pederson.
It is maintained by the Celery_ project, and used by kombu as a pure python
alternative when librabbitmq is not available.

This package contains pickles for %module_name.

%package docs
Summary: Documentation for %module_name
Group: Development/Documentation
BuildArch: noarch

%description docs
This is a fork of amqplib_ which was originally written by Barry Pederson.
It is maintained by the Celery_ project, and used by kombu as a pure python
alternative when librabbitmq is not available.

This package contains documentation for %module_name.

%if_with python3
%package -n python3-module-%module_name
Summary: fork of amqplib used by Kombu containing additional features and improvements
Group: Development/Python3

%description -n python3-module-%module_name
This is a fork of amqplib_ which was originally written by Barry Pederson.
It is maintained by the Celery_ project, and used by kombu as a pure python
alternative when librabbitmq is not available.
%endif

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if "%_target_libdir_noarch" != "%_libdir"
mv %buildroot%_target_libdir_noarch %buildroot%_libdir
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%module_name/

%check
python setup.py test

%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc AUTHORS Changelog LICENSE README.rst
%python_sitelibdir/%module_name
%python_sitelibdir/%module_name-%version-py*.egg-info
%exclude %python_sitelibdir/%module_name/pickle

%files pickles
%python_sitelibdir/%module_name/pickle

%files docs
%doc docs/_build/html/*

%if_with python3
%files -n python3-module-%module_name
%doc AUTHORS Changelog LICENSE README.rst
%python3_sitelibdir/%module_name
%python3_sitelibdir/%module_name-%version-py*.egg-info
%endif

%changelog
