%define _unpackaged_files_terminate_build 1
%define oname astroid

%def_with check

Name: python-module-%oname
Version: 1.6.4
Release: alt2

Summary: Python Abstract Syntax Tree New Generation
License: LGPLv2.1+
Group: Development/Python
# Source-git: https://github.com/PyCQA/astroid.git
Url: https://pypi.org/project/astroid

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires: python-module-setuptools
BuildRequires: python-module-pytest-runner

BuildArch: noarch

Provides: python-module-logilab-astng = %EVR
Obsoletes: python-module-logilab-astng <= 0.24.2

%py_requires backports.functools_lru_cache
%py_requires enum34
%py_requires singledispatch

%description
The aim of this module is to provide a common base representation of
python source code for projects such as pychecker, pyreverse, pylint...
Well, actually the development of this library is essentialy governed by
pylint's needs.
It extends class defined in the compiler.ast [1] module (python <= 2.4)
or in the builtin _ast module (python >= 2.5) with some additional
methods and attributes. Instance attributes are added by a builder
object, which can either generate extended ast (let's call them astng ;)
by visiting an existant ast tree or by inspecting living object. Methods
are added by monkey patching ast classes.

%prep
%setup
%patch0 -p1

%build
%python_build

%install
%python_install

%check
# python 2.7 tests are not supported more

%files
%doc ChangeLog README.rst
%python_sitelibdir/%oname/
%python_sitelibdir/*.egg-info
%exclude %python_sitelibdir/%oname/test*

%changelog
