%define _unpackaged_files_terminate_build 1
%define oname asyncio_mongo

%def_without python2
%def_with python3

Name: python-module-%oname
Version: 0.2.4
Release: alt2.1
Summary: Asynchronous Python 3.3+ driver for MongoDB
License: ASLv2.0
Group: Development/Python
Url: https://pypi.python.org/pypi/asyncio_mongo/

# https://bitbucket.org/mrdon/asyncio-mongo.git
Source: %oname-%version.zip

BuildRequires: unzip
%if_with python2
BuildRequires: python-devel python-module-setuptools
BuildRequires: python2.7(asyncio) python-module-nose
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3(asyncio) python3-module-nose
%endif

%py_provides %oname
%py_requires asyncio

%description
An asynchronous Python driver for the Mongo database, based on Python's
asyncio. This project is based on TxMongo.

%if_with python3
%package -n python3-module-%oname
Summary: Asynchronous Python 3.3+ driver for MongoDB
Group: Development/Python3
%py3_provides %oname
%py3_requires asyncio

%description -n python3-module-%oname
An asynchronous Python driver for the Mongo database, based on Python's
asyncio. This project is based on TxMongo.
%endif

%prep
%setup -q -n %{oname}-%{version}

%if_with python3
cp -fR . ../python3
%endif

%build
%if_with python2
%python_build_debug
%endif

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python2
%python_install
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
%if_with python2
python setup.py test
%endif
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%if_with python2
%files
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
