%def_with python3

Summary: An implementation the OpenBSD Blowfish password hashing algorithm
Version: 3.1.4
Release: alt1.2
%setup_python_module bcrypt
Name: python-module-bcrypt
Source0: %version.tar.gz
Source1: bfhash
Source2: bfhash.1
License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/bcrypt

BuildPreReq: python-devel python-module-setuptools
BuildRequires: python-module-pytest
BuildPreReq: python-module-six python-module-cffi
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytest
BuildPreReq: python3-devel python3-module-setuptools
BuildPreReq: python3-module-six python3-module-cffi
%endif

%description
py-bcrypt is an implementation the OpenBSD Blowfish password hashing
algorithm, as described in "A Future-Adaptable Password Scheme" by Niels
Provos and David Mazieres: http://www.openbsd.org/papers/bcrypt-paper.ps

This system hashes passwords using a version of Bruce Schneier's
Blowfish block cipher with modifications designed to raise the cost of
off-line password cracking. The computation cost of the algorithm is
parametised, so it can be increased as computers get faster.

%if_with python3
%package -n python3-module-bcrypt
Summary: An implementation the OpenBSD Blowfish password hashing algorithm
Group: Development/Python3

%description -n python3-module-bcrypt
py-bcrypt is an implementation the OpenBSD Blowfish password hashing
algorithm, as described in "A Future-Adaptable Password Scheme" by Niels
Provos and David Mazieres: http://www.openbsd.org/papers/bcrypt-paper.ps

This system hashes passwords using a version of Bruce Schneier's
Blowfish block cipher with modifications designed to raise the cost of
off-line password cracking. The computation cost of the algorithm is
parametised, so it can be increased as computers get faster.
%endif

%prep
%setup -n %modulename-%version

%build
%python_build_debug

%if_with python3
%python3_build_debug
%endif

%install
%python_install
install -D -m755 %SOURCE1 %buildroot%_bindir/bfhash
install -D %SOURCE2  %buildroot%_man1dir/bfhash.1

%if_with python3
%python3_install
install -D -m755 %SOURCE1 %buildroot%_bindir/bfhash.py3
sed -i 's|python|python3|' %buildroot%_bindir/bfhash.py3
%endif

%files
%doc *.rst
%python_sitelibdir/*
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%_man1dir/*

%if_with python3
%files -n python3-module-bcrypt
%doc *.rst
%python3_sitelibdir/*
%_bindir/*.py3
%exclude %_man1dir/bfhash*
%_man1dir/*
%endif

%check
PYTHONPATH=%buildroot%python_sitelibdir py.test
%if_with python3
PYTHONPATH=%buildroot%python3_sitelibdir py.test3
%endif

%changelog
