# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: /usr/bin/glib-gettextize /usr/bin/gtkdocize /usr/bin/xsltproc
# END SourceDeps(oneline)
%py_provides caja
%define _libexecdir %_prefix/libexec
%define oldname python-caja
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _description\
Python bindings for Caja

Name:           python-module-caja
Version:        1.20.0
Release:        alt2_1
Epoch:          1
Summary:        Python bindings for Caja

Group:          Development/Other
License:        GPLv2+ and LGPLv2+
URL:            http://mate-desktop.org
Source0:        http://pub.mate-desktop.org/releases/1.20/%{oldname}-%{version}.tar.xz

BuildRequires:  python-devel
BuildRequires:  mate-file-manager-devel
BuildRequires:  python-module-pygobject3-common-devel
BuildRequires:  mate-common
BuildRequires:  intltool
Source44: import.info


%description %_description

%package -n python-module-caja-devel
Summary:        Python bindings for Caja
Group:          Development/Other
Requires:       %{name} = %{epoch}:%{version}-%{release}

%description -n python-module-caja-devel
Python bindings for Caja


%prep
%setup -n %{oldname}-%{version} -q

sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/background-image.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/block-size-column.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/location-widget-provider.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/md5sum-property-page.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/open-terminal.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/submenu.py
sed -i -e 's~#!/usr/bin/python~#!%{__python}~g' examples/update-file-info-async.py

%build

%configure \
     --disable-static

%make_build


%install
%{makeinstall_std}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/caja-python/extensions
find $RPM_BUILD_ROOT -name '*.la' -delete

# We use %%doc instead
rm $RPM_BUILD_ROOT%{_docdir}/python-caja/README

%find_lang %{oldname} --with-gnome --all-name

%files -n python-module-caja -f %{oldname}.lang
%doc README AUTHORS COPYING NEWS
%{_libdir}/caja/extensions-2.0/libcaja-python.so
%{_datadir}/caja/extensions/libcaja-python.caja-extension
%dir %{_datadir}/caja-python
%dir %{_datadir}/caja-python/extensions
%{_docdir}/python-caja/examples/

%files -n python-module-caja-devel
%{_libdir}/pkgconfig/caja-python.pc


%changelog
