%global srcname ConfigArgParse

Name: python-module-configargparse
Version: 0.13.0
Release: alt1

Summary: A Python module with support for argparse, config files, and env variables

License: MIT
Group: Development/Python
Url: https://github.com/bw2/ConfigArgParse

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: https://pypi.io/packages/source/C/%srcname/%srcname-%version.tar.gz
Buildarch: noarch

BuildRequires: python-devel
BuildRequires: python-module-distribute

#if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools

%description
Applications with more than a handful of user-settable options are best
configured through a combination of command line args, config files, hard
coded defaults, and in some cases, environment variables.

Python's command line parsing modules such as argparse have very limited
support for config files and environment variables, so this module extends
argparse to add these features.

%package -n python3-module-configargparse
Group: Development/Python
Summary: %summary

%description -n python3-module-configargparse
Applications with more than a handful of user-settable options are best
configured through a combination of command line args, config files, hard
coded defaults, and in some cases, environment variables.

Python's command line parsing modules such as argparse have very limited
support for config files and environment variables, so this module extends
argparse to add these features.

%prep
%setup -n %srcname-%version

%build
%python_build
%python3_build

%install
%python_install
%python3_install

%files
%doc README.rst
%doc LICENSE
%python_sitelibdir/configargparse.py*
%python_sitelibdir/%{srcname}*.egg-info

%files -n python3-module-configargparse
%doc README.rst
%doc LICENSE
%python3_sitelibdir/configargparse.py*
%python3_sitelibdir/%{srcname}*.egg-info
%python3_sitelibdir/__pycache__/configargparse*

%changelog
