%define _unpackaged_files_terminate_build 1

%define oname contextlib2
%def_with check

Name: python-module-%oname
Version: 0.5.5
Release: alt2

Summary: Backports and enhancements for the contextlib module

Group: Development/Python
License: LGPLv2+
Url: https://pypi.org/project/contextlib2/

# Source-git: https://github.com/jazzband/contextlib2.git
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python-module-coverage
BuildRequires: python-module-unittest2
BuildRequires: python3-module-coverage
BuildRequires: python3-module-tox
%endif

%description
contextlib2 is a backport of the standard library's contextlib
module to earlier Python versions.

It also serves as a real world proving ground for possible
future enhancements to the standard library version.

%package -n python3-module-%oname
Summary: Backports and enhancements for the contextlib module
Group: Development/Python3

%description -n python3-module-%oname
contextlib2 is a backport of the standard library's contextlib
module to earlier Python versions.

It also serves as a real world proving ground for possible
future enhancements to the standard library version.

%prep
%setup
sed -i '/\[testenv\]/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/coverage3 \{envbindir\}\/coverage\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/coverage' tox.ini

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%check
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python}
tox.py3 --sitepackages -p auto -o -v

pushd ../python3
export TOXENV=py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%python_sitelibdir/contextlib2.py*
%python_sitelibdir/contextlib2-*.egg-info/

%files -n python3-module-%oname
%python3_sitelibdir/contextlib2.py
%python3_sitelibdir/__pycache__/contextlib2.cpython-*.py*
%python3_sitelibdir/contextlib2-*.egg-info/

%changelog
