%define _unpackaged_files_terminate_build 1
%define oname decorator

Name: python-module-%oname
Version: 4.3.0
Release: alt1
Summary: Better living through Python with decorators
License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/decorator
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source0: https://files.pythonhosted.org/packages/source/d/%oname/%oname-%version.tar.gz

BuildArch: noarch

BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
BuildRequires: python-module-setuptools

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools

%description
Python decorators are an interesting example of why syntactic sugar
matters. In principle, their introduction in Python changed nothing,
since they do not provide any new functionality which was not already
present in the language. In practice, their introduction has
significantly changed the way we structure our programs in Python. I
believe the change is for the best, and that decorators are a great idea
since:

* decorators help reducing boilerplate code;

* decorators help separation of concerns;

* decorators enhance readability and maintenability;

* decorators are explicit.

                     Michele Simionato <michele simionato at gmail com>

%package -n python3-module-%oname
Summary: Better living through Python 3 with decorators
Group: Development/Python3

%description -n python3-module-%oname
Python decorators are an interesting example of why syntactic sugar
matters. In principle, their introduction in Python changed nothing,
since they do not provide any new functionality which was not already
present in the language. In practice, their introduction has
significantly changed the way we structure our programs in Python. I
believe the change is for the best, and that decorators are a great idea
since:

* decorators help reducing boilerplate code;

* decorators help separation of concerns;

* decorators enhance readability and maintenability;

* decorators are explicit.

                     Michele Simionato <michele simionato at gmail com>

%prep
%setup -q -n %{oname}-%{version}

#install -Dm644 %SOURCE1 docs/README.rst

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd


%files
%doc CHANGES.md LICENSE.txt docs/README.rst
%python_sitelibdir/*

%files -n python3-module-%oname
%doc CHANGES.md LICENSE.txt docs/README.rst
%python3_sitelibdir/*

%changelog
