%define oname dill
%def_with python3

Name:           python-module-%oname
Version:        0.2.7.1
Release:        alt1.qa1
Summary:        Serialize all of Python
Group:          Development/Python
License:        BSD
URL:            https://github.com/uqfoundation/dill
BuildArch:      noarch

# https://github.com/uqfoundation/dill.git
Source: %name-%version.tar

BuildRequires: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
%endif

%description
Dill extends python's 'pickle' module for serializing and de-serializing
python objects to the majority of the built-in python types.
Dill provides the user the same interface as the 'pickle' module, and also
includes some additional features. In addition to pickling python objects, dill
provides the ability to save the state of an interpreter session in a single
command.

%if_with python3
%package -n python3-module-%oname
Summary: Serialize all of Python
Group: Development/Python3
%add_python3_req_skip __main__

%description -n python3-module-%oname
Dill extends python's 'pickle' module for serializing and de-serializing
python objects to the majority of the built-in python types.
Dill provides the user the same interface as the 'pickle' module, and also
includes some additional features. In addition to pickling python objects, dill
provides the ability to save the state of an interpreter session in a single
command.
%endif

%prep
%setup

%if_with python3
cp -a . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif


%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc LICENSE README.md
%python_sitelibdir/%oname
%python_sitelibdir/%oname-%version-py?.?.egg-info

%files -n python3-module-%oname
%doc LICENSE README.md
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version-py?.?.egg-info

%changelog
