%define branch 1.11
%define version %branch.29
%define release alt2
%define origname Django
%define oname django

%def_disable check

%setup_python_module django
%add_python_req_skip cx_Oracle
%add_findreq_skiplist %python_sitelibdir/%modulename/contrib/gis/db/backends/*/*

Summary: A high-level Python Web framework that encourages rapid development and clean, pragmatic design.
Name: python-module-%oname
Version: %version
Release: %release
Source0: %origname-%version.tar
License: BSD
Group: Development/Python
BuildArch: noarch
URL: http://www.djangoproject.com/
Provides: Django = %EVR
Provides: %name%branch = %EVR
Obsoletes: python-module-django2.2 < %EVR
Obsoletes: python-module-django1.5 < %EVR
Conflicts: python-module-django1.0 python-module-django1.1
Conflicts: python-module-django1.2
Provides: %name-tests = %EVR
Provides: %name%branch-tests = %EVR
Obsoletes: %name%branch-tests < %EVR
Obsoletes: python-module-django1.5-tests < %EVR
Conflicts: python-module-django1.0-tests
Conflicts: python-module-django1.1-tests
Conflicts: python-module-django1.2-tests


BuildRequires(pre): rpm-build-python
BuildRequires: python-module-six

%if_enabled check
BuildRequires: python-module-sqlparse
BuildRequires: python-module-pytz
BuildRequires: python-modules-sqlite3
BuildRequires: python-module-jinja2
BuildRequires: python-module-numpy
BuildRequires: python-module-pylibmc
BuildRequires: python-module-memcached
BuildRequires: python-module-yaml
BuildRequires: python-module-enum34
BuildRequires: python-module-selenium
BuildRequires: python-module-mock
BuildRequires: python-modules-wsgiref
%endif

%description
%summary

%package dbbackend-mysql
Summary: MySQLSQL support for Django.
Group: Development/Python
Requires: %name = %EVR
%py_requires MySQLdb
Provides: %name%branch-tests-mysql = %EVR
Obsoletes: %name%branch-tests-mysql < %EVR
Obsoletes: python-module-django1.5-dbbackend-mysql <= 1.5.0-alt3
Conflicts: python-module-django1.0-dbbackend-mysql
Conflicts: python-module-django1.1-dbbackend-mysql
Conflicts: python-module-django1.2-dbbackend-mysql

%description dbbackend-mysql
%summary

%package dbbackend-psycopg
Summary: PostgreSQL support for Django. (via psycopg)
Group: Development/Python
Requires: %name = %EVR
%py_requires psycopg
Provides: %name%branch-psycopg = %EVR
Obsoletes: %name%branch-psycopg < %EVR
Obsoletes: python-module-django1.5-dbbackend-psycopg <= 1.5.0-alt3
Conflicts: python-module-django1.0-dbbackend-psycopg
Conflicts: python-module-django1.1-dbbackend-psycopg
Conflicts: python-module-django1.2-dbbackend-psycopg

%description dbbackend-psycopg
%summary

%package dbbackend-psycopg2
Summary: PostgreSQL support for Django. (via psycopg2)
Group: Development/Python
Requires: %name = %EVR
%py_requires psycopg2
Provides: %name%branch-psycopg2 = %EVR
Obsoletes: %name%branch-psycopg2 < %EVR
Obsoletes: python-module-django1.5-dbbackend-psycopg2 <= 1.5.0-alt3
Conflicts: python-module-django1.0-dbbackend-psycopg2
Conflicts: python-module-django1.1-dbbackend-psycopg2
Conflicts: python-module-django1.2-dbbackend-psycopg2

%description dbbackend-psycopg2
%summary

%package dbbackend-sqlite3
Summary: SQLite3 support for Django.
Group: Development/Python
Requires: %name = %EVR
%py_requires sqlite3
Provides: %name%branch-sqlite3 = %EVR
Obsoletes: %name%branch-sqlite3 < %EVR
Obsoletes: python-module-django1.5-dbbackend-sqlite3 <= 1.5.0-alt3
Conflicts: python-module-django1.0-dbbackend-sqlite3
Conflicts: python-module-django1.1-dbbackend-sqlite3
Conflicts: python-module-django1.2-dbbackend-sqlite3

%description dbbackend-sqlite3
%summary

%package doc
Summary: Django documentation
Group: Development/Documentation
Provides: %name%branch-doc = %EVR
Obsoletes: %name%branch-doc < %EVR
Obsoletes: python-module-django1.5-doc <= 1.5.0-alt3
Obsoletes: python3-module-django-doc <= 1.5.0-alt1.alpha
Conflicts: python-module-django1.0-doc
Conflicts: python-module-django1.1-doc
Conflicts: python-module-django1.2-doc

%description doc
%summary

%prep
%setup -n %origname-%version

# Use system six instead of bundled
find -type f -name '*.py*' -exec sed -i 's|django.utils.six|six|'  -- '{}' +

find -type f -name '*.py*' -exec sed -i 's|%_bindir/env python|%_bindir/python2|' -- '{}' +
find -type f -name '*.py' -exec sed -i 's|.*from future_builtins import zip.*||' -- '{}' +

%build
%python_build

%install
export LC_ALL=en_US.UTF-8
%python_install
mv %buildroot%_bindir/django-admin.py %buildroot%_bindir/django-admin.py2

# remove .po files
find %buildroot -name "*.po" | xargs rm -f


%check
export PYTHONPATH=$(pwd)
cd tests
LANG="en_US.UTF-8" python runtests.py --settings=test_sqlite --verbosity=2 --parallel 1

%files
%_bindir/django-admin.py2
%python_sitelibdir/*

%exclude %python_sitelibdir/%modulename/db/backends/mysql/
#exclude %python_sitelibdir/%modulename/db/backends/postgresql/
%exclude %python_sitelibdir/%modulename/db/backends/postgresql_psycopg2/
%exclude %python_sitelibdir/%modulename/db/backends/sqlite3/

%files doc
%doc docs

%files dbbackend-mysql
%python_sitelibdir/%modulename/db/backends/mysql/

#files dbbackend-psycopg
#python_sitelibdir/%modulename/db/backends/postgresql/

%files dbbackend-psycopg2
%python_sitelibdir/%modulename/db/backends/postgresql_psycopg2/

%files dbbackend-sqlite3
%python_sitelibdir/%modulename/db/backends/sqlite3/

%changelog
