%define oname django-richcomments

%def_with python3
%def_with bootstrap

Name: python-module-%oname
Version: 0.0.2
Release: alt2
Summary: Django app extending the builtin comments framework for AJAX style commenting
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/django-richcomments/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/praekelt/django-richcomments.git
Source: %name-%version.tar
BuildArch: noarch

BuildPreReq: python-devel python-module-setuptools
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel python3-module-setuptools
%endif

%description
django-richcomments wraps the Django's comments frameworks existing
render_comment_list and render_comment_form template tags to make them
behave AJAXy.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
django-richcomments wraps the Django's comments frameworks existing
render_comment_list and render_comment_form template tags to make them
behave AJAXy.

This package contains tests for %oname.

%package -n python3-module-%oname
Summary: Django app extending the builtin comments framework for AJAX style commenting
Group: Development/Python3
%if_with bootstrap
%add_python3_req_skip django.conf.urls.defaults
%add_python3_req_skip django.contrib.comments.templatetags.comments
%endif

%description -n python3-module-%oname
django-richcomments wraps the Django's comments frameworks existing
render_comment_list and render_comment_form template tags to make them
behave AJAXy.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
django-richcomments wraps the Django's comments frameworks existing
render_comment_list and render_comment_form template tags to make them
behave AJAXy.

This package contains tests for %oname.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests.*

%files tests
%python_sitelibdir/*/tests.*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests.*
%exclude %python3_sitelibdir/*/*/tests.*

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests.*
%python3_sitelibdir/*/*/tests.*
%endif

%changelog
