%define oname django-taggit

%def_with python3
%def_with bootstrap

Name: python-module-%oname
Version: 0.23.0
Release: alt1
Summary: Simple tagging for django
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/django-taggit
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# https://github.com/alex/django-taggit.git
Source: %name-%version.tar
BuildArch: noarch

#BuildPreReq: python-devel python-module-setuptools
#BuildPreReq: python-module-sphinx-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
#BuildPreReq: python3-devel python3-module-setuptools
%endif

BuildRequires(pre): rpm-macros-sphinx
# Automatically added by buildreq on Thu Jan 28 2016 (-bi)
# optimized out: python-base python-devel python-module-PyStemmer python-module-Pygments python-module-babel python-module-cssselect python-module-genshi python-module-jinja2 python-module-jinja2-tests python-module-markupsafe python-module-pytz python-module-setuptools python-module-six python-module-snowballstemmer python-module-sphinx python-module-sphinx_rtd_theme python-modules python-modules-compiler python-modules-ctypes python-modules-email python-modules-encodings python-modules-json python-modules-multiprocessing python-modules-unittest python3 python3-base
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python3-module-setuptools rpm-build-python3 time
BuildRequires: python-module-isort
BuildRequires: python3-module-isort

%description
django-taggit is a reusable Django application for simple tagging.

%package -n python3-module-%oname
Summary: Simple tagging for django
Group: Development/Python3
%if_with bootstrap
%add_python3_req_skip django.db.models.related
%endif

%description -n python3-module-%oname
django-taggit is a reusable Django application for simple tagging.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html

%files
%doc AUTHORS *.txt* *.rst docs/_build/html
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%doc AUTHORS *.txt* *.rst docs/_build/html
%python3_sitelibdir/*
%endif

%changelog
