%def_with python3

%define oname futurist

Name: python-module-%oname
Version: 1.7.0
Release: alt1
Summary: Useful additions to futures, from the future
Group: Development/Python
License: ASL 2.0
Url: http://docs.openstack.org/developer/futurist
Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
BuildArch: noarch

#Requires: python-module-six >= 1.9.0
Requires: python-module-monotonic
Requires: python-module-futures >= 3.0
Requires: python-module-contextlib2 >= 0.4.0

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr >= 2.0.0
BuildRequires: python-module-six >= 1.10.0
BuildRequires: python-module-monotonic >= 0.6
BuildRequires: python-module-futures >= 3.0
BuildRequires: python-module-contextlib2 >= 0.4.0
BuildRequires: python-module-prettytable >= 0.7.1
BuildRequires: python-module-sphinx
BuildRequires: python-module-openstackdocstheme >= 1.18.1
BuildRequires: python-module-reno >= 2.5.0

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 2.0.0
BuildRequires: python3-module-six >= 1.10.0
BuildRequires: python3-module-monotonic >= 0.6
BuildRequires: python3-module-contextlib2 >= 0.4.0
BuildRequires: python3-module-prettytable >= 0.7.1
%endif

%description
Code from the future, delivered to you in the now.

%package doc
Summary: Documentation for futurist library
Group: Development/Documentation

%description doc
Documentation for futurist library.

%package tests
Summary: Tests for futurist library
Group: Development/Python
BuildArch: noarch

%description tests
Tests for futurist library.

%package -n python3-module-%oname
Summary: Useful additions to futures, from the future
Group: Development/Python3

#Requires: python3-module-six >= 1.9.0
Requires: python3-module-monotonic
Requires: python3-module-contextlib2 >= 0.4.0

%description -n python3-module-%oname
Code from the future, delivered to you in the now.

%package -n python3-module-%oname-tests
Summary: Tests for futurist library
Group: Development/Python3
BuildArch: noarch

%description -n python3-module-%oname-tests
Tests for futurist library.

%prep
%setup -n %oname-%version

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

export PYTHONPATH="$( pwd ):$PYTHONPATH"
pushd doc
sphinx-build -b html -d build/doctrees source build/html
popd
# Fix hidden-file-or-dir warnings
rm -fr doc/build/html/.buildinfo


%install
%python_install
%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc README.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files doc
%doc doc/build/html

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%oname
%doc README.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%oname-tests
%python3_sitelibdir/*/tests
%endif

%changelog
