%define oname gdata

%def_without python3

Name: python-module-gdata
Version: 2.0.18
Release: alt3.git20160102

Summary: A Python module for accessing online Google services

Group: Development/Python
License: Apache-2.0
Url: https://github.com/google/gdata-python-client

# Source0-git:	https://github.com/google/gdata-python-client.git
Source: %name-%version-%release.tar

BuildArch: noarch

BuildRequires: python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python-tools-2to3
%endif

%description
This is a Python module for accessing online Google services, such as:
- Blogger
- Calendar
- Picasa Web Albums
- Spreadsheets
- YouTube
- Notebook
and other

%package docs
Summary: Documentation for %oname
Group: Development/Documentation

%description docs
This is a Python module for accessing online Google services, such as:
- Blogger
- Calendar
- Picasa Web Albums
- Spreadsheets
- YouTube
- Notebook
and other

This package contains documentation for %oname.

%package -n python3-module-%oname
Summary: A Python module for accessing online Google services
Group: Development/Python3

%description -n python3-module-%oname
This is a Python module for accessing online Google services, such as:
- Blogger
- Calendar
- Picasa Web Albums
- Spreadsheets
- YouTube
- Notebook
and other

%prep
%setup

%if_with python3
cp -fR . ../python3
rm -f ../python3/samples/apps/emailsettings_pop_settings.py
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build
chmod -x samples/*/*.py
rm -rf src/gdata/Crypto/test.py
rm -rf src/gdata/Crypto/Util/test.py

%if_with python3
pushd ../python3
%python3_build
chmod -x samples/*/*.py
rm -rf src/gdata/Crypto/test.py
rm -rf src/gdata/Crypto/Util/test.py
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
chmod -x samples/*/*.py
rm -rf src/gdata/Crypto/test.py
rm -rf src/gdata/Crypto/Util/test.py
popd
%endif

%files
%doc *.txt
%python_sitelibdir/atom/
%python_sitelibdir/gdata/
%python_sitelibdir/*.egg-info

%files docs
%doc pydocs/*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%python3_sitelibdir/atom/
%python3_sitelibdir/gdata/
%python3_sitelibdir/*.egg-info
%endif

%changelog
