%define _name gst-python
%define ver_major 1.16
%define gst_api_ver 1.0
%define _gst_libdir %_libdir/gstreamer-%gst_api_ver

%def_with python2
%def_disable check

%ifarch %valgrind_arches
%def_enable valgrind
%endif

Name: python-module-gst%gst_api_ver
Version: %ver_major.1
Release: alt1

Summary: GStreamer overrides for PyGobject
Group: Development/Python
License: LGPL2+
Url: http://gstreamer.freedesktop.org/

Provides: %_name = %version-%release
Provides: python-module-gst = %version-%release

Source: http://gstreamer.freedesktop.org/src/%_name/%_name-%version.tar.xz
Patch: %name-1.5.2-python-libs.patch

BuildRequires(pre): rpm-build-gir rpm-build-python3 rpm-macros-valgrind
BuildRequires: orc liborc-test-devel  gcc-c++ gst-plugins%gst_api_ver-devel >= %version
BuildRequires: python3-devel python3-module-pygobject3-devel python3-module-pytest
%if_enabled valgrind
BuildRequires: valgrind-tool-devel
%endif
%{?_enable_check:BuildRequires: /proc gstreamer%gst_api_ver gst-plugins-base%gst_api_ver}
%if_with python2
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel python-modules-distutils python-module-pygobject3-devel
BuildRequires: python-modules-compiler python-module-pytest
%endif

%description
This package provides GStreamer overrides for PyGobject.

%package -n python3-module-gst%gst_api_ver
Summary: GStreamer overrides for PyGobject
Group: Development/Python3
Provides: python3-module-gst = %version-%release

%description -n python3-module-gst%gst_api_ver
This package provides GStreamer overrides for PyGobject.

%prep
%setup -n %_name-%version -a0
mv %_name-%version py2build
for d in . %{?_with_python2:py2build}; do
pushd $d
%patch
popd
done

%build
%autoreconf
%configure PYTHON=%__python3
%make_build

%if_with python2
pushd py2build
%autoreconf
%configure PYTHON=%__python
%make_build
popd
%endif

%install
%makeinstall_std

%if_with python2
pushd py2build
%makeinstall_std
popd
%endif

%check
%make check

%if_with python2
pushd py2build
%make check
popd
%endif

%if_with python2
%files
%python_sitelibdir/gi/overrides/*
%exclude %python_sitelibdir/gi/overrides/*.la
# gstreamer plugin
%exclude %_gst_libdir/libgstpython.*
%doc AUTHORS NEWS
%endif

%files -n python3-module-gst%gst_api_ver
%python3_sitelibdir/gi/overrides/*
%exclude %python3_sitelibdir/gi/overrides/*.la
%doc AUTHORS NEWS

%changelog
