%define _unpackaged_files_terminate_build 1
%define oname jsonrpcserver

%def_with python3
%def_without python2
%def_disable check

Name: python-module-%oname
Version: 3.5.3
Release: alt1.1
Summary: JSON-RPC 2.0 server library
License: LGPL
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/jsonrpcserver

Source: %oname-%version.tar

%if_with python2
BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-jsonschema
BuildRequires: python-module-nose python-module-pytest
%endif
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-jsonschema
BuildRequires: python3-module-nose python3-module-pytest
%endif

%py_provides %oname

%description
A JSON-RPC 2.0 server library for Python 3.

%if_with python3
%package -n python3-module-%oname
Summary: JSON-RPC 2.0 server library
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
A JSON-RPC 2.0 server library for Python 3.
%endif

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%if_with python2
%python_build_debug
%endif

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%if_with python2
%python_install
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
%if_with python2
rm -fR build
py.test
%endif
%if_with python3
pushd ../python3
rm -fR build
py.test3
popd
%endif

%if_with python2
%files
%doc *.md
%python_sitelibdir/*
%endif

%if_with python3
%files -n python3-module-%oname
%doc *.md
%python3_sitelibdir/*
%endif

%changelog
