%def_enable check
%def_with python3

%define oname logilab-common
Name: python-module-%oname
Version: 1.4.1
Release: alt3

Summary: Useful miscellaneous modules used by Logilab projects
License: LGPLv2.1+
Group: Development/Python

Url: http://www.logilab.org/project/logilab-common
Packager: Python Development Team <python@packages.altlinux.org>

# Do not install /usr/bin/pytest from there
# and use it instead of ours quietly;
# an explicit "Requires: pytest" is needed.
Conflicts: python-module-pytest = 3.0.5-alt1

BuildArch: noarch

# hg clone http://hg.logilab.org/review/logilab/common/
Source: %name-%version.tar

%py_requires mx.DateTime
%add_python_req_skip mercurial sphinx

%setup_python_module %oname

%{?!_without_check:%{?!_disable_check:BuildRequires: /proc %py_dependencies mx.DateTime unittest2}}
BuildRequires: python-module-egenix-mx-base python-module-pytz python-module-unittest2
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pytz python3-module-setuptools python3-module-six
%endif

%description
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging

%if_with python3
%package -n python3-module-%oname
Summary: Useful miscellaneous modules used by Logilab projects (Python 3)
Group: Development/Python3
# Do not install /usr/bin/pytest3 from there
# and use it instead of ours quietly;
# an explicit "Requires: pytest3" is needed.
Conflicts: python-module-pytest = 3.0.5-alt1
%add_python3_req_skip kerberos mercurial sphinx
%add_python3_req_skip six.moves
%py3_requires six

%description -n python3-module-%oname
logilab-common is a collection of low-level Python packages and modules,
designed to ease:
  * handling command line options and configuration files
  * writing interactive command line tools
  * manipulation files and character strings
  * interfacing to OmniORB (removed by packager)
  * generating of SQL queries
  * running unit tests
  * manipulating tree structures
  * accessing RDBMS (currently postgreSQL, mysql and sqlite)
  * generating text and HTML reports
  * logging
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . -T ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
cp setup.py -T setup.py.back
find -type f -name '*.py' -exec sed -i 's|unittest2|unittest|g' -- '{}' +
find -type f -name '*.py' -exec 2to3 -w -n '{}' +
mv -f setup.py.back -T setup.py
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
install -p -m644 logilab/__init__.py \
	-t %buildroot%python3_sitelibdir/logilab/
install -pD -m644 doc/logilab-pytest.1 -T %buildroot%_man1dir/logilab-pytest-3.1
popd
mv %buildroot%_bindir/logilab-pytest -T %buildroot%_bindir/logilab-pytest-3
%endif

%python_install
install -p -m644 logilab/__init__.py \
	-t %buildroot%python_sitelibdir/logilab/
install -pD -m644 doc/logilab-pytest.1 -T %buildroot%_man1dir/logilab-pytest.1

%check
PYTHONPATH=%buildroot%python_sitelibdir \
    %buildroot%_bindir/logilab-pytest \
    -t test \
    -s test_4
%if_with python3
pushd ../python3
PYTHONPATH=%buildroot%python3_sitelibdir \
    %buildroot%_bindir/logilab-pytest-3 \
    -t test \
    -s test_4
popd
%endif

%global _unpackaged_files_terminate_build 1
%files
%_bindir/logilab-pytest
%python_sitelibdir/logilab/
%python_sitelibdir/*.egg-info
%python_sitelibdir/*.pth
%_man1dir/logilab-pytest.1*
%doc ChangeLog README

%if_with python3
%files -n python3-module-%oname
%_bindir/logilab-pytest-3
%python3_sitelibdir/logilab/
%python3_sitelibdir/*.egg-info
%python3_sitelibdir/*.pth
%_man1dir/logilab-pytest-3.1*
%doc ChangeLog README
%endif

%changelog
