%define _unpackaged_files_terminate_build 1
%define modname markdown

%def_with python3
%def_disable check

Name: python-module-%modname
Version: 3.1.1
Release: alt1

Summary: Python implementation of Markdown text-to-HTML convertor.
Group: Development/Python
License: %gpl2plus | %bsd
Url: http://pypi.python.org/pypi/Markdown/

#VCS: git://github.com/waylan/Python-Markdown.git
Source: https://pypi.io/packages/source/M/Markdown/Markdown-%{version}.tar.gz

%setup_python_module %modname

BuildArch: noarch

BuildRequires(pre): rpm-build-licenses

BuildRequires(pre): python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-yaml python-modules-logging
BuildRequires: python-module-nose python-module-coverage
BuildRequires: python-modules-xml
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-yaml
BuildRequires: python3-module-nose python3-module-coverage
%endif

Conflicts: discount
%py_provides %modname
%py_requires yaml logging xml

%description
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains Python implementation of markdown-to-HTML convertor.

%if_with python3
%package -n python3-module-%modname
Summary: Python 3 implementation of Markdown text-to-HTML convertor
Group: Development/Python3

%description -n python3-module-%modname
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.
%endif

%package docs
Summary: Documentation for Markdown
Group: Development/Documentation
BuildArch: noarch

%description docs
Markdown is a plain text formatting syntax designed to be as readable as
possible while being structured enough to allow conversion to other formats.

This package contains documentation for Markdown.

%prep
%setup -q -n Markdown-%version
%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
popd
mv %buildroot%_bindir/%{modname}_py \
	%buildroot%_bindir/%{modname}_py3
%endif

%python_install

ln -s %{modname}_py %buildroot%_bindir/%modname

%check
nosetests -v
%if_with python3
pushd ../python3
nosetests3 -v
popd
%endif

export PYTHONPATH=%buildroot%python_sitelibdir
%buildroot%_bindir/%modname README.md >README.html

%files
%_bindir/*
%if_with python3
%exclude %_bindir/%{modname}_py3
%endif
%python_sitelibdir/*


%if_with python3
%files -n python3-module-%modname
%_bindir/%{modname}_py3
%python3_sitelibdir/*
%endif

%changelog
