%def_with python3

Name: python-module-openid
Version: 2.2.5
Release: alt2.2

Summary: OpenID support for servers and consumers

Group: Development/Python
License: GPL
Url: http://www.openidenabled.com/

Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

#setup_python_module openid
%define modulename openid

Source: http://openidenabled.com/files/python-openid/packages/python-openid-%version.tar.bz2

# Automatically added by buildreq on Wed May 14 2008
BuildRequires: python-devel

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildPreReq: python-tools-2to3
%endif

%description
This is a set of Python packages to support use of the OpenID
decentralized identity system in your application.
Want to enable single sign-on for your web site?
Use the openid.consumer package.
Want to run your own OpenID server? Check out openid.server.
Includes example code and support for a variety of storage back-ends.

%package -n python3-module-%modulename
Summary: OpenID support for servers and consumers
Group: Development/Python3

%description -n python3-module-%modulename
This is a set of Python packages to support use of the OpenID
decentralized identity system in your application.
Want to enable single sign-on for your web site?
Use the openid.consumer package.
Want to run your own OpenID server? Check out openid.server.
Includes example code and support for a variety of storage back-ends.

%package examples
Summary: Examples for OpenOD Python package
Group: Development/Python
BuildArch: noarch
Conflicts: %name < %version-%release

%description examples
This is a set of Python packages to support use of the OpenID
decentralized identity system in your application.
Want to enable single sign-on for your web site?
Use the openid.consumer package.
Want to run your own OpenID server? Check out openid.server.
Includes example code and support for a variety of storage back-ends.

This package contains examples for OpenOD Python package.

%prep
%setup -n python-%modulename-%version

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%files
%doc README CHANGES* LICENSE NEWS NOTICE *.txt
%python_sitelibdir/%modulename/
%python_sitelibdir/*.egg-info

%files examples
%doc examples

%if_with python3
%files -n python3-module-%modulename
%doc README CHANGES* LICENSE NEWS NOTICE *.txt
%python3_sitelibdir/%modulename/
%python3_sitelibdir/*.egg-info
%endif

%changelog
