%define oname oslosphinx

%def_with python3

Name: python-module-%oname
Version: 4.18.0
Release: alt1
Summary: OpenStack Sphinx Extensions and Theme
License: ASLv2.0
Group: Development/Python
Url: http://docs.openstack.org/developer/oslosphinx

# https://github.com/openstack/oslosphinx.git
Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-pbr >= 1.8
BuildRequires: python-module-requests >= 2.10.0
BuildRequires: python-module-six >= 1.9.0
BuildRequires: python-module-sphinx-devel >= 1.2.1
BuildRequires: python-module-hacking >= 0.10.0
BuildRequires: python-module-reno >= 1.8.0
BuildRequires: python-module-openstackdocstheme

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-pbr >= 1.8
BuildRequires: python3-module-requests >= 2.10.0
BuildRequires: python3-module-six >= 1.9.0
BuildRequires: python3-module-sphinx-devel >= 1.2.1
BuildRequires: python3-module-hacking >= 0.10.0
BuildRequires: python3-module-reno >= 1.8.0
BuildRequires: python3-module-openstackdocstheme
%endif

%py_provides %oname

%description
Theme and extension support for Sphinx documentation from the OpenStack
project.

%package -n python3-module-%oname
Summary: OpenStack Sphinx Extensions and Theme
Group: Development/Python3
%py3_provides %oname
%py3_requires hacking

%description -n python3-module-%oname
Theme and extension support for Sphinx documentation from the OpenStack
project.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Theme and extension support for Sphinx documentation from the OpenStack
project.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Theme and extension support for Sphinx documentation from the OpenStack
project.

This package contains documentation for %oname.

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx doc
ln -s ../objects.inv doc/source/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

pushd doc
sphinx-build -b pickle -d build/doctrees source build/pickle
sphinx-build -b html -d build/doctrees source build/html
popd

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/

%files
%doc *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc doc/build/html/*

%if_with python3
%files -n python3-module-%oname
%doc *.rst
%python3_sitelibdir/*
%endif

%changelog
