%global pypi_name pbr

%def_with doc
%def_with python3

%define descr \
PBR is a library that injects some useful and sensible default behaviors \
into your setuptools run. It started off life as the chunks of code that \
were copied between all of the OpenStack projects. Around the time that \
OpenStack hit 18 different projects each with at least 3 active \
branches, it seems like a good time to make that code into a proper \
re-usable library.

Name:       python-module-%pypi_name
Version:    5.4.2
Release:    alt1

Summary:    Python Build Reasonableness

Group:      Development/Python
License:    ASL 2.0
URL:        http://pypi.python.org/pypi/pbr

# git://git.openstack.org/openstack-dev/pbr
Source: %name-%version.tar

BuildRequires: python-module-setuptools python-module-unittest2 python-module-d2to1
BuildRequires: python-module-pbr
BuildRequires: python-module-html5lib python-module-mimeparse
BuildRequires: python-module-alabaster python-module-docutils python-module-subunit-tests python-module-oslosphinx
BuildRequires: python-module-sphinxcontrib-apidoc
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3-module-unittest2 python3-module-d2to1
BuildRequires: python3-module-pbr
BuildRequires: python3-module-html5lib python3-module-mimeparse
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

BuildArch:  noarch

%description
%descr

%package -n python3-module-%pypi_name
Summary:    Python Build Reasonableness
Group:      Development/Python3
Requires:   python3-module-pip

%description -n python3-module-%pypi_name
%descr

%package -n python3-module-%pypi_name-tests
Summary: Tests for PBR library (Python 3)
Group: Development/Python3
Requires: python3-module-%pypi_name = %version-%release

%description -n python3-module-%pypi_name-tests
Tests for PBR library (Python 3)

%package tests
Summary: Tests for PBR library
Group: Development/Python
Requires: %name = %version-%release

%description tests
Tests for PBR library

%prep
%setup
# Remove the requirements file so that pbr hooks don't add it
# to distutils requiers_dist config
rm -rf {test-,}requirements.txt

# Remove bundled egg-info
rm -rf %{pypi_name}.egg-info

%if_with python3
cp -fR . ../python3
%endif

%build
export PBR_VERSION="%version"

export SKIP_PIP_INSTALL=1
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%if_with doc
# generate html docs
sphinx-build doc/source html
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
export PBR_VERSION="%version"

%if_with python3
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
    mv $i $i.py3
done
popd
%endif

%python_install

%files
%doc README.rst LICENSE
%if_with doc
%doc html
%endif
%_bindir/*
%if_with python3
%exclude %_bindir/*.py3
%endif
%python_sitelibdir/%pypi_name-%version-py*.egg-info
%python_sitelibdir/%pypi_name
%exclude %python_sitelibdir/%pypi_name/tests

%files tests
%python_sitelibdir/%pypi_name/tests


%if_with python3
%files -n python3-module-%pypi_name
%doc README.rst LICENSE
%_bindir/*.py3
%python3_sitelibdir/%pypi_name-%version-py*.egg-info
%python3_sitelibdir/%pypi_name
%exclude %python3_sitelibdir/%pypi_name/tests

%files -n python3-module-%pypi_name-tests
%python3_sitelibdir/%pypi_name/tests

%endif

%changelog
