%define oname persistent

%def_with python3

Name: python-module-%oname
Version: 4.2.4.2
Release: alt1.1.1.qa1

%setup_python_module %oname

Summary: Translucent persistent objects
License: ZPL 2.1
Group: Development/Python

Url: http://www.zope.org/Products/ZODB

# https://github.com/zopefoundation/persistent.git
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv python-module-repoze.sphinx.autointerface
BuildRequires: python-devel python-module-coverage python-module-nose python-module-setuptools python-module-zope
BuildRequires: python-module-tox
BuildRequires: python-module-virtualenv
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-coverage python3-module-nose python3-module-setuptools python3-module-zope
BuildRequires: python3-module-tox
BuildRequires: python3-module-virtualenv
%endif

%py_provides persistent.TimeStamp

%description
This package contains a generic persistence implementation for Python.
It forms the core protocol for making objects interact "transparently"
with a database such as the ZODB.

%package docs
Summary: Documentation for translucent persistent objects
Group: Development/Documentation
BuildArch: noarch

%description docs
This package contains documentation for persistence implementation for
Python. It forms the core protocol for making objects interact
"transparently" with a database such as the ZODB.

%package tests
Summary: Tests for translucent persistent objects
Group: Development/Python
Requires: %name = %EVR

%description tests
This package contains a generic tests persistence implementation for
Python. It forms the core protocol for making objects interact
"transparently" with a database such as the ZODB.

%if_with python3
%package -n python3-module-%oname
Summary: Sample python3 module specfile
Group: Development/Python
%py3_provides persistent.TimeStamp

%description -n python3-module-%oname
This specfile is provided as sample specfile for python3 module
packages. It contains most of usual tags and constructions used in such
specfiles.

%package -n python3-module-%oname-tests
Summary: Sample python3 module tests specfile
Group: Development/Python
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
This specfile is provided as sample specfile for python3 module tests
packages. It contains most of usual tags and constructions used in such
specfiles.
%endif

%prep
%setup

%if_with python3
cp -a . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%add_optflags -fno-strict-aliasing
%python_build
%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
install -p -m644 persistent/_compat.h \
	%buildroot%_includedir/python%_python3_version%_python3_abiflags/
popd
%endif

%python_install
install -p -m644 persistent/_compat.h \
	%buildroot%_includedir/python%_python_version/

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html

%check
export PIP_INDEX_URL=http://host.invalid./
export PYTHONPATH=%python_sitelibdir:%python_sitelibdir_noarch
TOX_TESTENV_PASSENV='PYTHONPATH' tox -e py%{python_version_nodots python}-pure-cffi -v

%if_with python3
pushd ../python3
export PYTHONPATH=%python3_sitelibdir:%python3_sitelibdir_noarch
TOX_TESTENV_PASSENV='PYTHONPATH' tox.py3 -e py%{python_version_nodots python3} -v
popd
%endif

%files
%doc *.txt
%_includedir/python%_python_version
%python_sitelibdir/%oname/
%exclude %python_sitelibdir/%oname/test*
%python_sitelibdir/*.egg-info

%files tests
%python_sitelibdir/%oname/test*

%files docs
%doc docs/_build/html/*

%if_with python3
%files -n python3-module-%oname
%doc *.txt
%_includedir/python%_python3_version%_python3_abiflags
%python3_sitelibdir/%oname/
%exclude %python3_sitelibdir/%oname/test*
%python3_sitelibdir/*.egg-info

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/test*
%endif

%changelog
