%define _unpackaged_files_terminate_build 1

%def_with docs

Summary: The PyPA recommended tool for installing Python packages
Name: python-module-pip
Version: 19.1.1
Release: alt2
Source0: pip-%version.tar.gz
License: MIT
Group: Development/Python
BuildArch: noarch
Url: http://www.pip-installer.org
Obsoletes: python-module-pip-pickles
%setup_python_module pip

%if_with docs
BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-module-sphinx
BuildRequires: python3-module-sphinx
%endif

BuildRequires(pre): rpm-build-python3

%description
%summary
%add_findprov_skiplist %python_sitelibdir/pip/_vendor/*

%if_with docs
%package docs
Summary: Documentation for pip
Group: Development/Documentation

%description docs
%summary

This package contains documentation for pip.
%endif

%package -n pip
Summary: Executable for PIP
Group: Development/Python
Requires: python-module-pip
Obsoletes: python-module-pip <= 19.1.1-alt1
Conflicts: python-module-pip <= 19.1.1-alt1

%description -n pip
%summary

%package -n python3-module-%modulename
Summary: The PyPA recommended tool for installing Python packages
Group: Development/Python3
Obsoletes: python3-module-pip-pickles

%description -n python3-module-%modulename
%summary
%add_findprov_skiplist %python3_sitelibdir/pip/_vendor/*
%filter_from_requires /python3\(\.[[:digit:]]\)\?(pip\._vendor\..*)/d

%if_with docs
%package -n python3-module-%modulename-docs
Summary: Documentation for pip3
Group: Development/Documentation

%description -n python3-module-%modulename-docs
%summary

This package contains documentation for pip.
%endif

%prep
%setup -n %modulename-%version

%if_with docs
# XXX wait for packaging pypa_theme
sed -i '
s/pypa_theme/default/
/.navigation_depth.: 3,/s/^/#/
/.issues_url.:/s/^/#/
' docs/html/conf.py

%prepare_sphinx .
ln -s ../objects.inv docs/
%endif

%build
# py2 and py3 builds are identical
%python_build

%if_with docs
PYTHONPATH=`pwd`/build/lib sphinx-build-3 -c docs/html docs/html html3

PYTHONPATH=`pwd`/build/lib sphinx-build -c docs/html docs/html html2
%endif

%install
%python3_install
%python_install

%files
%doc *.txt *.rst
%_bindir/pip2
%_bindir/pip2.7
%python_sitelibdir/pip/
%python_sitelibdir/pip-*.egg-info/

%files -n pip
%_bindir/pip

%if_with docs
%files docs
%doc html2

%files -n python3-module-%modulename-docs
%doc html3
%endif

%files -n python3-module-%modulename
%doc *.txt *.rst
%_bindir/pip3
%_bindir/pip%{__python3_version}
%python3_sitelibdir/pip/
%python3_sitelibdir/pip-*.egg-info/

%changelog
