%define _unpackaged_files_terminate_build 1
%define mname pyasn1

%def_with check

Name: python-module-%mname
Version: 0.4.5
Release: alt1

Summary: Abstract Syntax Notation One (ASN.1), Python implementation
License: %bsdstyle
Group: Development/Python
# Source-git: https://github.com/etingof/pyasn1.git
Url: https://pypi.python.org/pypi/pyasn1

Source0: %name-%version.tar
Source1: pyasn1.watch
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-licenses

%if_with check
BuildRequires: python-modules-unittest
%endif

BuildArch: noarch

%description
This is an implementation of ASN.1 types and codecs in Python programming
language. It has been first written to support particular protocol (SNMP)
but then generalized to be suitable for a wide range of protocols
based on ASN.1 specification.

%package -n python3-module-%mname
Summary: Abstract Syntax Notation One (ASN.1), Python 3 implementation
Group: Development/Python3

%description -n python3-module-%mname
This is an implementation of ASN.1 types and codecs in Python3 programming
language. It has been first written to support particular protocol (SNMP)
but then generalized to be suitable for a wide range of protocols
based on ASN.1 specification.

%prep
%setup
%patch -p1

rm -rf ../python3
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%check
python setup.py test

pushd ../python3
python3 setup.py test
popd

%files
%doc LICENSE.rst README.md CHANGES.rst
%python_sitelibdir/pyasn1/
%python_sitelibdir/pyasn1-%version-*.egg-info/

%files -n python3-module-%mname
%doc LICENSE.rst README.md CHANGES.rst
%python3_sitelibdir/pyasn1/
%python3_sitelibdir/pyasn1-%version-*.egg-info/

%changelog
