%define _unpackaged_files_terminate_build 1
%define mname pyasn1-modules

%def_with check

Name: python-module-%mname
Version: 0.2.4
Release: alt1

Summary: ASN.1 modules for Python
License: %bsdstyle
Group: Development/Python
# Source-git: https://github.com/etingof/pyasn1-modules.git
Url: https://pypi.python.org/pypi/pyasn1-modules

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-build-licenses

BuildRequires: python-module-pyasn1 >= 0.4.1
BuildRequires: python-module-setuptools
BuildRequires: python3-module-pyasn1 >= 0.4.1
BuildRequires: python3-module-setuptools

%if_with check
BuildRequires: pytest
BuildRequires: pytest3
%endif

Requires: python-module-pyasn1 >= 0.4.1
BuildArch: noarch

%description
This is a small but growing collection of ASN.1 data structures
expressed in Python terms using pyasn1 data model.

It's thought to be useful to protocol developers and testers.

%package -n python3-module-%mname
Summary: ASN.1 modules for Python 3
Group: Development/Python3
Requires: python3-module-pyasn1 >= 0.4.1

%description -n python3-module-%mname
This is a small but growing collection of ASN.1 data structures
expressed in Python terms using pyasn1 data model.

It's thought to be useful to protocol developers and testers.

%prep
%setup
cp -a . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%check
pytest -v

pushd ../python3
pytest3 -v
popd

%files
%doc LICENSE.txt README.md
%python_sitelibdir/pyasn1_modules/
%python_sitelibdir/pyasn1_modules-%version-*.egg-info/

%files -n python3-module-%mname
%doc LICENSE.txt README.md
%python3_sitelibdir/pyasn1_modules/
%python3_sitelibdir/pyasn1_modules-%version-*.egg-info/

%changelog
