%def_with doc

%define modname cairo
%define oname py%modname
%define ver_major 1.18

Name: python-module-%oname
Version: %ver_major.1
Release: alt1

Summary: Pycairo is a set of Python bindings for the cairo vector graphics library
Group: Development/Python
License: LGPLv2.1/MPLv1.1
Url: https://github.com/pygobject/pycairo

# VCS: https://github.com/pygobject/pycairo.git
Source: %url/releases/download/v%version/%oname-%version.tar.gz

%setup_python_module %modname

BuildRequires(pre): rpm-build-python rpm-build-python3
BuildRequires: libcairo-devel >= 1.13.1
BuildRequires: python-devel python3-devel
%{?!_with_bootstrap:BuildRequires: python-module-Pygments}
%if_with doc
BuildRequires: python-module-sphinx-devel python-module-sphinx_rtd_theme
BuildRequires: python3-module-sphinx-devel python3-module-sphinx_rtd_theme
BuildRequires: texlive-latex-base
%endif

%description
The Pycairo bindings are designed to match the cairo C API as closely as
possible, and to deviate only in cases which are clearly better implemented in
a more 'Pythonic' way.

%package -n python3-module-%oname
Summary: Python3 bindings for Cairo
Group: Development/Python3

%description -n python3-module-%oname
This package provides Python3 wrappers for Cairo library

%package -n python3-module-%oname-devel
Summary: Development files for pycairo
Group: Development/Python
Requires: python3-module-%oname = %version-%release
Requires: %name-common-devel = %version-%release

%description -n python3-module-%oname-devel
Development files for pycairo.

%package common-devel
Summary: Common development files for %oname
Group: Development/Python

%description common-devel
Common development files for %oname used for both python2 and python3.

%package devel
Summary: Development files for pycairo
Group: Development/Python
Requires: %name = %version-%release
Requires: %name-common-devel = %version-%release

%description devel
Development files for pycairo.

%package docs
Summary: Documentation for pycairo
Group: Development/Documentation
BuildArch: noarch

%description docs
Documentation for pycairo.

%package tests
Summary: Tests for pycairo
Group: Development/Python
Requires: %name = %version-%release

%description tests
Documentation for pycairo.

%package examples
Summary: Examples for pycairo
Group: Development/Python
Requires: %name = %version-%release

%description examples
Examples for pycairo.

%package pickles
Summary: Pickles for pycairo
Group: Development/Python

%description pickles
Pickles for pycairo.

%prep
%setup -n %oname-%version -a0
mv %oname-%version py3build
# fix pc-file install
subst 's|\"lib\"|"%_lib"|' {,py3build/}setup.py

%{?_with_doc:%prepare_sphinx docs}

%build
# incomplete support
%define opts --pkgconfigdir=%_pkgconfigdir
%python_build
%{?_with_doc:%make -C docs}

pushd py3build
%python3_build
popd

%install
pushd py3build
%python3_install
popd

%python_install

# docs
install -d %buildroot%_docdir/%name-%version
install -p -m644 NEWS README* \
	%buildroot%_docdir/%name-%version

%if_with doc
cp -fR docs/_build/reference %buildroot%_docdir/%name-%version/

# pickles
install -d %buildroot%python_sitelibdir/%oname/pickle
cp -fR docs/_build/.doctrees/* %buildroot%python_sitelibdir/%oname/pickle/

# tests and examples
cp -fR examples tests %buildroot%python_sitelibdir/%modulename/
for i in $(find %buildroot%python_sitelibdir/%modulename/examples -type d)
do
	touch $i/__init__.py
done

%pre pickles
rm -fR %python_sitelibdir/%oname/pickle
%endif # doc

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README*
%python_sitelibdir/%modulename

%if_with doc
%exclude %python_sitelibdir/%modulename/tests
%exclude %python_sitelibdir/%modulename/examples
%endif

%files -n python3-module-%oname
%python3_sitelibdir/%modname/

%files common-devel
%_includedir/%oname/

%files devel
%_pkgconfigdir/%oname.pc

%files -n python3-module-%oname-devel
%_pkgconfigdir/py3cairo.pc

%if_with doc
%files docs
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version
%exclude %_docdir/%name-%version/NEWS
%exclude %_docdir/%name-%version/README*

%files tests
%python_sitelibdir/%modulename/tests

%files examples
%python_sitelibdir/%modulename/examples

%files pickles
%dir %python_sitelibdir/%oname
%python_sitelibdir/%oname/pickle/
%endif

%changelog
