%define oname pycryptopp

Name: python-module-%oname
Version: 0.7.1
Release: alt2

Summary: Python wrappers for a few algorithms from the Crypto++ library
License: GPLv2+ or other (see copyright)
Group: Development/Python
Url: https://pypi.python.org/pypi/pycryptopp/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# Source-git: https://github.com/tahoe-lafs/pycryptopp.git
Source: %name-%version.tar

# fix build with libcryptopp >= 6 https://gist.github.com/skydrome/bb9665fc0b449167bb25a57b45829ca8
Patch1: libcryptopp-6.patch

BuildPreReq: gcc-c++ git-core
BuildPreReq: libcryptopp-devel >= 6
BuildPreReq: python-devel python-module-setuptools
BuildPreReq: python-module-ecdsa python-module-ed25519

%py_provides %oname
%py_requires ecdsa ed25519

%description
pycryptopp is a python wrapper around a few algorithms from the Crypto++
and python-Ed25519 libraries.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
pycryptopp is a python wrapper around a few algorithms from the Crypto++
and python-Ed25519 libraries.

This package contains tests for %oname.

%prep
%setup
%patch1

sed -i 's|@VERSION@|%version|' \
	src/pycryptopp/publickey/ed25519/_version.py
git init-db
git config user.email "real at altlinux.org"
git config user.name "REAL"
git add . -A
git commit -a -m "%oname-%version"
git tag %oname-%version -m "%oname-%version"

%build
%python_build_debug --disable-embedded-cryptopp

%install
%python_install
rm -rf %_docdir/pycryptopp/

%check
python setup.py test

%files
%doc COPYING* copyright *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/test*
%exclude %python_sitelibdir/*/bench

%files tests
%python_sitelibdir/*/test*
%python_sitelibdir/*/bench

%changelog
