%define _unpackaged_files_terminate_build 1

%def_with python3
%def_without python2
%if_with python2
%def_with docs
%else
%def_without docs
%endif

%define oname pyface

Name: python-module-%oname
Version: 6.1.2
Release: alt2
Summary: Traits-capable windowing framework

Group: Development/Python
License: BSD, EPL and LGPL
URL: https://docs.enthought.com/pyface/
BuildArch: noarch

# https://github.com/enthought/pyface.git
Source: %name-%version.tar

Patch1: %oname-alt-docs.patch

%if_with python2
BuildRequires: python-module-setuptools python-devel
BuildRequires: python-module-setupdocs
%endif

%if_with docs
BuildRequires(pre): python-module-sphinx-devel
BuildRequires: python2.7(traits)
%endif

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
%endif

%description
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

%package tests
Summary: Tests for pyface
Group: Development/Python
Requires: %name = %EVR

%description tests
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

This package contains tests for pyface.

%if_with python3
%package -n python3-module-%oname
Summary: Traits-capable windowing framework
Group: Development/Python3
# skip wx requirements
%add_python3_req_skip pyface.ui.wx.split_dialog IPython.frontend.wx.wx_frontend IPython.kernel.core.interpreter
%add_python3_req_skip apptools.io.file
%add_python3_req_skip traitsui.wx traitsui.wx.helper wx.html wx.lib.agw wx.lib.gridmovers wx.lib.layoutf wx.lib.mixins.grid
%add_python3_req_skip wx.lib.scrolledpanel wx.lib.wxpTag wx.py wx.py.pseudo wx.py.shell wx.py.version wx.stc wx.wx wx.xrc

%description -n python3-module-%oname
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

%package -n python3-module-%oname-tests
Summary: Tests for pyface
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

This package contains tests for pyface.
%endif

%if_with docs
%package docs
Summary: Documentation for pyface
Group: Development/Documentation

%description docs
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

This package contains documentation for pyface.

%package pickles
Summary: Pickles for pyface
Group: Development/Python

%description pickles
The pyface project contains a toolkit-independent GUI abstraction layer,
which is used to support the "visualization" features of the Traits
package.  Thus, you can write code in terms of the Traits API (views,
items, editors, etc.), and let pyface and your selected toolkit and
back-end take care of the details of displaying them.

This package contains pickles for pyface.
%endif

%prep
%setup
%patch1 -p1

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%if_with docs
%prepare_sphinx docs
ln -s ../objects.inv docs/source/
%endif

%build
%if_with python2
%python_build_debug
%endif

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%if_with docs
%make -C docs html
%make -C docs pickle
%endif

%install
%if_with python2
%python_install
%endif

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if_with docs
# pickles
cp -fR docs/build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%if_with python2
%files
%doc image_LICENSE*.txt LICENSE.txt
%doc CHANGES.txt README.rst
%python_sitelibdir/*
%if_with docs
%exclude %python_sitelibdir/%oname/pickle
%endif
%exclude %python_sitelibdir/%oname/tests
%exclude %python_sitelibdir/%oname/*/tests
%exclude %python_sitelibdir/%oname/*/*/tests
%exclude %python_sitelibdir/%oname/*/*/*/tests
%exclude %python_sitelibdir/%oname/*/testing.py*
%exclude %python_sitelibdir/%oname/*/*/*/testing.py*
%exclude %python_sitelibdir/%oname/*/*/*/gui_test_assistant.py*
%exclude %python_sitelibdir/%oname/*/*/*/modal_dialog_tester.py*

%files tests
%python_sitelibdir/%oname/tests
%python_sitelibdir/%oname/*/tests
%python_sitelibdir/%oname/*/*/tests
%python_sitelibdir/%oname/*/*/*/tests
%python_sitelibdir/%oname/*/testing.py*
%python_sitelibdir/%oname/*/*/*/testing.py*
%python_sitelibdir/%oname/*/*/*/gui_test_assistant.py*
%python_sitelibdir/%oname/*/*/*/modal_dialog_tester.py*
%endif

%if_with docs
%files docs
%doc docs/build/html examples docs/*.txt docs/*.doc docs/*.pdf docs/*.ppt

%files pickles
%python_sitelibdir/%oname/pickle
%endif

%if_with python3
%files -n python3-module-%oname
%doc image_LICENSE*.txt LICENSE.txt
%doc CHANGES.txt README.rst
%python3_sitelibdir/*
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/tests
%exclude %python3_sitelibdir/%oname/*/*/tests
%exclude %python3_sitelibdir/%oname/*/*/*/tests
%exclude %python3_sitelibdir/%oname/*/testing.py*
%exclude %python3_sitelibdir/%oname/*/*/testing*.py*
%exclude %python3_sitelibdir/%oname/*/*/*/testing.py*
%exclude %python3_sitelibdir/%oname/*/*/*/*/testing*.py*
%exclude %python3_sitelibdir/%oname/*/*/*/gui_test_assistant.py*
%exclude %python3_sitelibdir/%oname/*/*/*/modal_dialog_tester.py*
%exclude %python3_sitelibdir/%oname/*/*/*/*/gui_test_assistant*.py*
%exclude %python3_sitelibdir/%oname/*/*/*/*/modal_dialog_tester*.py*

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/*/tests
%python3_sitelibdir/%oname/*/*/tests
%python3_sitelibdir/%oname/*/*/*/tests
%python3_sitelibdir/%oname/*/testing.py*
%python3_sitelibdir/%oname/*/*/testing*.py*
%python3_sitelibdir/%oname/*/*/*/testing.py*
%python3_sitelibdir/%oname/*/*/*/*/testing*.py*
%python3_sitelibdir/%oname/*/*/*/gui_test_assistant.py*
%python3_sitelibdir/%oname/*/*/*/modal_dialog_tester.py*
%python3_sitelibdir/%oname/*/*/*/*/gui_test_assistant*.py*
%python3_sitelibdir/%oname/*/*/*/*/modal_dialog_tester*.py*
%endif

%changelog
