%def_disable gtk_doc
%def_disable evince
%def_disable nautilusburn
%def_disable panel
%def_disable media
%def_disable brasero
%def_disable gnomedesktop
%def_enable wnck
%def_disable totem_plparser
%def_disable bugbuddy
%def_disable metacity
%def_disable evolution
%def_disable gnomeprint
%def_disable gnomeprintui

%define major 2.32
%define oname gnome-python-desktop
%define extras_version 2.19

Name: python-module-pygnome-desktop
Version: %major.0
Release: alt8

Summary: Python modules for some GNOME libraries part of the GNOME Desktop

License: LGPL
Group: Development/Python
Url: http://www.pygtk.org/

Packager: GNOME Maintainers Team <gnome@packages.altlinux.org>

Source: http://ftp.gnome.org/pub/GNOME/sources/%oname/%major/%oname-%version.tar.bz2

%define bname python-module-pygnome
%define python_gnome_dir %python_sitelibdir/gtk-2.0/gnome

%{?_enable_evince:BuildRequires: libevince-gtk-devel >= 2.32.0 }
%{?_enable_nautilusburn:BuildRequires: libnautilus-cd-burner-devel}
%{?_enable_panel:BuildRequires: libgnome-panel-devel}
%{?_enable_media:BuildRequires: gnome-media-devel}
%{?_enable_brasero:BuildRequires: libbrasero-devel >= 2.32.0}
%{?_enable_totem_plparser:BuildRequires: libtotem-pl-parser-devel}
%{?_enable_gnomedesktop:BuildRequires: libgnome-desktop-devel}
%{?_enable_wnck:BuildRequires: libwnck-devel}
%{?_enable_metacity:BuildRequires: libmetacity-devel}
%{?_enable_bugbuddy:BuildRequires: bug-buddy}
%{?_enable_evolution:BuildRequires: evolution-data-server-devel}
%{?_enable_gnomeprint:BuildRequires: libgnomeprint-devel}
%{?_enable_gnomeprintui:BuildRequires: libgnomeprintui-devel}
%{?_enable_gtop:BuildRequires: libgtop-devel}
BuildRequires: libgnome-keyring-devel
BuildRequires: librsvg-devel python-module-pycairo-devel libgtksourceview-devel
BuildRequires: libgnomeui-devel

BuildRequires: python-module-pygnome-devel >= 2.28.0
BuildRequires: python-module-pygtk-devel >= 2.22.0

%description
GnomePythonDesktop provides python interfacing modules for some
GNOME libraries part of the GNOME Desktop (gnomeapplet, gnomeprint,
gnomeprint.ui, gtksourceview, wnck, totem.plparser, gtop, nautilusburn,
mediaprofiles, metacity).

%package devel
Summary: files needed to build extra wrappers for GNOME libraries
Group: Development/Python
Requires: %name = %version-%release
Requires: %name-devel
Requires: %bname-extras-devel >= %extras_version

%description devel
This package contains files required to build wrappers for GNOME
libraries so that they interoperate with pygnome.

%package devel-doc
Summary: Development documentation for extra wrappers for GNOME libraries
Group: Development/Python
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains development documentation required to develop
wrappers for GNOME libraries so that they interoperate with pygnome.

%package examples
Summary: Example programs that use extra wrappers for GNOME libraries
Group: Development/Python
BuildArch: noarch
Conflicts: %name < %version

%description examples
This package contains example program that use wrappers for GNOME libraries

%package -n %bname-applet
Summary: Python bindings for GNOME Panel applets
Group: System/Libraries
Obsoletes: pygnome-applet
Obsoletes: gnome-python2-applet
Provides: gnome-python2-applet
Requires: %name = %version-%release

%description -n %bname-applet
This module contains a wrapper that allows GNOME Panel applets to be
written in Python.

%package -n %bname-gtkhtml2
Summary: Python bindings for interacting with gtkhtml2
Group: System/Libraries
Requires: %name = %version-%release
Obsoletes: gnome-python2-gtkhtml2
Provides: gnome-python2-gtkhtml2

%description -n %bname-gtkhtml2
This module contains a wrapper that allows the use of gtkhtml2 via Python.

%package -n %bname-gnomeprint
Summary: Python bindings for interacting with libgnomeprint
Group: System/Libraries
Obsoletes: gnome-python2-gnomeprint
Provides: gnome-python2-gnomeprint

%description -n %bname-gnomeprint
This module contains a wrapper that allows the use of libgnomeprint via Python.

%package -n %bname-wnck
Summary: Python bindings for interacting with libwnck
Group: System/Libraries

%description -n %bname-wnck
This module contains a wrapper that allows the use of libwnck via Python.

%package -n %bname-nautilusburn
Summary: Python bindings for interacting with nautilus burn
Group: System/Libraries
Requires: %name = %version-%release

%description -n %bname-nautilusburn
This module contains a wrapper that allows the use of nautilusburn via Python

%package -n %bname-brasero
Summary: Python bindings for interacting with Brasero
Group: System/Libraries
Requires: %name = %version-%release

%description -n %bname-brasero
This module contains a wrapper that allows the use of Brasero via Python

%package -n %bname-totem
Summary: Python bindings for interacting with totem
Group: System/Libraries

%description -n %bname-totem
This module contains a wrapper that allows the use of totem via Python

%package -n %bname-metacity
Summary: Python bindings for interacting with metacity
Group: System/Libraries
Requires: %name = %version-%release

%description -n %bname-metacity
This module contains a wrapper that allows the use of metacity via Python

%package -n %bname-evolution
Summary: Python bindings for interacting with evolution
Group: System/Libraries
Requires: %name = %version-%release

%description -n %bname-evolution
This module contains a wrapper that allows the use of evolution via Python

%package -n %bname-gnome-keyring
Summary: Python bindings for interacting with gnome-keyring
Group: System/Libraries

%description -n %bname-gnome-keyring
This module contains a wrapper that allows the use of gnome-keyring via Python

%package -n %bname-evince
Summary: Python bindings for interacting with Evince
Group: System/Libraries
Obsoletes: python-module-evince
Provides: python-module-evince = %version-%release

%description -n %bname-evince
This module contains a wrapper that allows the use of Evince document
viewer via Python

%prep
%setup -q -n %oname-%version

%build
export CFLAGS="$CFLAGS `pkg-config --cflags gtk+-2.0`"
%configure --disable-dependency-tracking \
	%{subst_enable gnomedesktop} \
	%{?_disable_evolution:--disable-evolution} \
	%{?_disable_evolution:--disable-evolution_ecal} \
	%{subst_enable bugbuddy} \
	%{subst_enable metacity} \
	%{subst_enable nautilusburn} \
	%{subst_enable gnomeprint} \
	%{subst_enable gnomeprintui} \
	%{subst_enable totem_plparser} \
	%{subst_enable gtop} \
	%{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall

mkdir -p %buildroot%_docdir/%name
cp -R examples %buildroot%_docdir/%name/

%files
%{?_enable_gtop:%python_sitelibdir/gtk-2.0/gtop.so}
%python_sitelibdir/gtk-2.0/rsvg.so
%{?_enable_media:%python_sitelibdir/gtk-2.0/mediaprofiles.so}
%{?_enable_bugbuddy:%python_sitelibdir/gtk-2.0/bugbuddy.*}
%{?_enable_gnomedesktop:%python_sitelibdir/gtk-2.0/gnomedesktop/}
%dir %_docdir/%name
%doc AUTHORS ChangeLog README NEWS

%files devel
%_pkgconfigdir/*
%_datadir/pygtk/2.0/defs/*.defs

%files examples
%_docdir/%name/examples

%if_enabled gtk_doc
%files devel-doc
%_datadir/gtk-doc/html/*
%endif

%if_enabled wnck
%files -n %bname-wnck
%python_sitelibdir/gtk-2.0/wnck.so
%endif

%files -n %bname-gnome-keyring
%python_sitelibdir/gtk-2.0/gnomekeyring.so

%if_enabled panel
%files -n %bname-applet
%python_gnome_dir/applet.*
%python_sitelibdir/gtk-2.0/gnomeapplet.so
%endif

%if_enabled gnomeprint
%files -n %bname-gnomeprint
%python_sitelibdir/gtk-2.0/gnomeprint/
%endif

%if_enabled totem
%files -n %bname-totem
%python_sitelibdir/gtk-2.0/totem/
%endif

%if_enabled nautilusburn
%files -n %bname-nautilusburn
%python_sitelibdir/gtk-2.0/nautilusburn.so
%endif

%if_enabled brasero
%files -n %bname-brasero
%python_sitelibdir/gtk-2.0/braseroburn.so
%python_sitelibdir/gtk-2.0/braseromedia.so
%endif

%if_enabled metacity
%files -n %bname-metacity
%python_sitelibdir/gtk-2.0/metacity.so
%endif

%if_enabled evolution
%files -n %bname-evolution
%python_sitelibdir/gtk-2.0/evolution/
%endif

%if_enabled evince
%files -n %bname-evince
%python_sitelibdir/gtk-2.0/evince.so
%endif

%exclude %python_sitelibdir/gtk-2.0/*.la

%changelog
