%define module_name pygraphviz

%def_with python3

Name: python-module-%module_name
Version: 1.5
Release: alt2

Summary: Python wrapper for the Graphviz Agraph data structure

License: BSD
Group: Development/Python
Url: https://pygraphviz.github.io/
Packager: Denis Klimov <zver@altlinux.org>

# https://github.com/pygraphviz/pygraphviz.git
Source: %module_name-%version.tar

BuildRequires: libgraphviz-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-distribute
%endif

%setup_python_module %module_name
%add_python_req_skip tests

%description
Python wrapper for the Graphviz Agraph data structure.
It can be used to create and draw networks and graphs with Graphviz.

%package tests
Summary: Tests for %module_name
Group: Development/Python
Requires: %name = %version-%release
%add_python3_req_skip tests

%description tests
Python wrapper for the Graphviz Agraph data structure.
It can be used to create and draw networks and graphs with Graphviz.

This package contains tests for %module_name.

%if_with python3
%package -n python3-module-%module_name
Summary: Python 3 wrapper for the Graphviz Agraph data structure
Group: Development/Python3

%description -n python3-module-%module_name
Python wrapper for the Graphviz Agraph data structure.
It can be used to create and draw networks and graphs with Graphviz.

%package -n python3-module-%module_name-tests
Summary: Tests for %module_name (Python 3)
Group: Development/Python3
Requires: python3-module-%module_name = %version-%release

%description -n python3-module-%module_name-tests
Python wrapper for the Graphviz Agraph data structure.
It can be used to create and draw networks and graphs with Graphviz.

This package contains tests for %module_name.
%endif

%prep
%setup -n %module_name-%version

%build
%add_optflags -I%_includedir/graphviz

%python_build_debug -b build2
%if_with python3
%python3_build_debug -b build3
%endif

%install
ln -sf build2 build
%python_install
%if_with python3
ln -sf build3 build
%python3_build_install
%endif

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/*/tests

%files tests
%python_sitelibdir/*/tests

%if_with python3
%files -n python3-module-%module_name
%python3_sitelibdir/*
%doc %_docdir/*
%exclude %python3_sitelibdir/*/tests

%files -n python3-module-%module_name-tests
%python3_sitelibdir/*/tests
%endif

%changelog
