%define _unpackaged_files_terminate_build 1
%define module_name pyjsonrpc

%def_without python3

Name: python-module-%module_name
Version: 0.10.0
Release: alt2.1
Summary: json-rpc package which implements JSON-RPC over HTTP
License: LGPL
Group: Development/Python
BuildArch: noarch
Url: http://json-rpc.org/wiki/python-json-rpc

# https://github.com/gerold-penz/python-jsonrpc.git
Source: python-jsonrpc-%{version}.tar.gz


%setup_python_module %module_name
BuildRequires: python-module-setuptools python-module-bunch
BuildRequires: python-modules-json
BuildRequires: python-module-munch
BuildRequires: python-module-six
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools python3-module-bunch
BuildRequires: python-tools-2to3
%endif

Obsoletes: python-module-jsonrpc < %EVR

%description
Simple Reference JSON-RPC Implementation for Django

%if_with python3
%package -n python3-module-%module_name
Summary: json-rpc package which implements JSON-RPC over HTTP
Group: Development/Python3

%description -n python3-module-%module_name
Simple Reference JSON-RPC Implementation for Django
%endif

%prep
%setup -q -n python-jsonrpc-%{version}

%if_with python3
cp -fR . ../python3
find ../python3 -type f -name '*.py' -exec 2to3 -w -n '{}' +
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%check
python setup.py test
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

%files
%doc *.rst examples version.txt
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%module_name
%doc *.rst examples version.txt
%python3_sitelibdir/*
%endif

%changelog
