%define oname pyramid

%def_with python3
%def_without bootstrap

Name:           python-module-%oname
Version:        1.9.1
Release:        alt2.qa1
Summary:        The Pyramid web application framework, a Pylons project
Group:          Development/Python
License:        BSD
URL:            https://trypyramid.com/
BuildArch:      noarch

# https://github.com/Pylons/pyramid.git
Source: %name-%version.tar

BuildRequires: python-devel python-module-setuptools python2.7(chameleon) python2.7(mako) python2.7(repoze.lru)
BuildRequires: python2.7(venusian) python2.7(webtest) python2.7(zope.deprecation)
BuildRequires: python2.7(docutils) python2.7(hupper) python2.7(paste.deploy)
BuildRequires: python2.7(plaster) python2.7(plaster_pastedeploy) python2.7(sphinx)
BuildRequires: python2.7(translationstring) python2.7(zope.component) python2.7(zope.configuration)
BuildRequires: python2.7(zope.interface) python2.7(webob)
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools python3(chameleon) python3(mako) python3(repoze.lru)
BuildRequires: python3(venusian) python3(webtest) python3(zope.deprecation)
BuildRequires: python3(docutils) python3(hupper) python3(paste.deploy)
BuildRequires: python3(plaster) python3(plaster_pastedeploy) python3(sphinx)
BuildRequires: python3(translationstring) python3(zope.component) python3(zope.configuration)
BuildRequires: python3(zope.interface) python3(webob)
%endif

%py_requires repoze.lru zope.interface zope.deprecation paste.deploy plaster_pastedeploy

%if_with bootstrap
# break cyclic dependency on bootstrap
%add_python_req_skip pyramid_zodbconn
%endif

%description
Pyramid is a small, fast, down-to-earth, open source Python web development
framework. It makes real-world web application development and deployment more
fun, more predictable, and more productive.

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
Pyramid is a small, fast, down-to-earth, open source Python web development
framework. It makes real-world web application development and deployment more
fun, more predictable, and more productive.

This package contains tests for %oname.

%if_with python3
%package -n python3-module-%oname
Group:          Development/Python3
Summary:        The Pyramid web application framework, a Pylons project

%py3_requires paste.deploy plaster_pastedeploy

%if_with bootstrap
# break cyclic dependency on bootstrap
%add_python3_req_skip pyramid_zodbconn
%endif

%description -n python3-module-%oname
Pyramid is a small, fast, down-to-earth, open source Python web development
framework. It makes real-world web application development and deployment more
fun, more predictable, and more productive.

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Pyramid is a small, fast, down-to-earth, open source Python web development
framework. It makes real-world web application development and deployment more
fun, more predictable, and more productive.

This package contains tests for %oname.
%endif

%prep
%setup

%if_with python3
cp -a . ../python3
%endif

%build
%python_build

%if_with python3
pushd ../python3
%python3_build
popd
%endif

%install
%if_with python3
pushd ../python3
%python3_install
cp -r pyramid/scaffolds/alchemy %buildroot/%python3_sitelibdir/pyramid/scaffolds/.
cp -r pyramid/scaffolds/starter %buildroot/%python3_sitelibdir/pyramid/scaffolds/.
cp -r pyramid/scaffolds/zodb %buildroot/%python3_sitelibdir/pyramid/scaffolds/.

# Create the Python 3 executables.
for e in pcreate pserve prequest proutes pshell ptweens pviews pdistreport; do
    mv %buildroot/%_bindir/$e %buildroot/%_bindir/$e-3
done;

popd
%endif

%python_install
cp -r pyramid/scaffolds/alchemy %buildroot/%python_sitelibdir/pyramid/scaffolds/.
cp -r pyramid/scaffolds/starter %buildroot/%python_sitelibdir/pyramid/scaffolds/.
cp -r pyramid/scaffolds/zodb %buildroot/%python_sitelibdir/pyramid/scaffolds/.

%check
%if_with python3
pushd ../python3
python3 setup.py test
popd
%endif

python setup.py test

%files
%doc README.rst LICENSE.txt
%python_sitelibdir/%oname/
%python_sitelibdir/%{oname}-%{version}*.egg-info
%exclude %python_sitelibdir/%oname/tests
%_bindir/pcreate
%_bindir/pdistreport
%_bindir/prequest
%_bindir/proutes
%_bindir/pserve
%_bindir/pshell
%_bindir/ptweens
%_bindir/pviews

%files tests
%python_sitelibdir/%oname/tests

%if_with python3
%files -n python3-module-%oname
%doc README.rst LICENSE.txt
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{oname}-%{version}*.egg-info
%exclude %python3_sitelibdir/%oname/tests
%_bindir/pcreate-3
%_bindir/pdistreport-3
%_bindir/prequest-3
%_bindir/proutes-3
%_bindir/pserve-3
%_bindir/pshell-3
%_bindir/ptweens-3
%_bindir/pviews-3

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%endif

%changelog
