%define _unpackaged_files_terminate_build 1
%define oname pytest

%def_with check

Name: python-module-%oname
Version: 3.10.1
Release: alt5

Summary: Python test framework
License: MIT
Group: Development/Python
# Source-git: https://github.com/pytest-dev/pytest.git
Url: https://pypi.python.org/pypi/pytest

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python-module-setuptools_scm
BuildRequires: python3-module-setuptools_scm

%if_with check
BuildRequires: /dev/pts
BuildRequires: python-module-argcomplete
BuildRequires: python-module-pathlib2
BuildRequires: python-module-funcsigs
BuildRequires: python-module-pluggy
BuildRequires: python-module-atomicwrites
BuildRequires: python-module-more-itertools
BuildRequires: python-module-json
BuildRequires: python-module-hypothesis
BuildRequires: python-module-mock
BuildRequires: python-module-decorator
BuildRequires: python-module-numpy
BuildRequires: python-module-pexpect
BuildRequires: python-module-nose
BuildRequires: python3-module-argcomplete
BuildRequires: python3-module-decorator
BuildRequires: python3-module-atomicwrites
BuildRequires: python3-module-more-itertools
BuildRequires: python3-module-funcsigs
BuildRequires: python3-module-hypothesis
BuildRequires: python3-module-mock
BuildRequires: python3-module-nose
BuildRequires: python3-module-numpy
BuildRequires: python3-module-pexpect
BuildRequires: python3-module-requests
BuildRequires: python3-module-tox
%endif

%py_requires py
%py_requires funcsigs
%py_requires pathlib2

BuildArch: noarch

%description
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n pytest
Summary: Additional executable for pytest
Group: Development/Python
Requires: python-module-%oname = %EVR
# It simply has executables with the same filename:
Conflicts: python-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n python3-module-%oname
Summary: Python3 test framework
Group: Development/Python3

%description -n python3-module-%oname
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%package -n pytest3
Summary: Additional executable for pytest
Group: Development/Python3
Requires: python3-module-%oname = %EVR
# It simply has executables with the same filename:
Conflicts: python3-module-logilab-common < 1.0.2-alt2.hg20150708

%description -n pytest3
The pytest framework makes it easy to write small tests, yet
scales to support complex functional testing for applications and libraries.

%prep
%setup
%patch -p1

# adjust timeouts for testing on aarch64/beehive
grep -qs 'child\.expect(.*)' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1
grep -qs 'child\.expect_exact([[:space:]]*$' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1
grep -qs 'testdir\.spawn_pytest([[:space:]]*$' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py} || exit 1

sed -i -e '/child\.expect(.*)/s/)[[:space:]]*$/, timeout=60)/g;' \
-e '/child\.expect_exact([[:space:]]*$/{$!N;s/\n\([[:space:]]*\)\(.*\)/\n\1\2,\n\1timeout=60,/g}' \
-e '/testdir\.spawn_pytest(.*)/s/)[[:space:]]*$/, expect_timeout=30)/g;' \
-e '/testdir\.spawn_pytest([[:space:]]*$/{$!N;s/\n\([[:space:]]*\)\(.*\)/\n\1\2,\n\1expect_timeout=30,/g}' \
-e 's/\([[:space:]]*\)child\.sendline(\x22p .*)$/&\n\1import time; time.sleep(child.delaybeforesend)/g' \
testing/{test_pdb.py,test_terminal.py,test_unittest.py}

rm -rf ../python3
cp -a . ../python3

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_build

pushd ../python3
%python3_build
popd

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version

pushd ../python3
%python3_install
mv %buildroot%_bindir/py.test -T %buildroot%_bindir/py.test3
mv %buildroot%_bindir/pytest -T %buildroot%_bindir/pytest3
popd

%python_install

%check
sed -i '/pytest --lsof {posargs}$/{s/{posargs}$/--ignore testing\/test_pdb.py --ignore testing\/test_terminal.py --ignore testing\/test_unittest.py &/g}' tox.ini
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
%define python2_nodots py%{python_version_nodots python}
%define python3_nodots py%{python_version_nodots python3}
export TOXENV=%python2_nodots,%python2_nodots-pexpect,%python3_nodots,%python3_nodots-pexpect
tox.py3 --sitepackages -p auto -o -v -- --cache-clear

%files
%doc AUTHORS LICENSE *.rst
%_bindir/py.test
%python_sitelibdir/pytest.py*
%python_sitelibdir/_pytest/
%python_sitelibdir/pytest-*.egg-info/

%files -n pytest
%_bindir/pytest

%files -n python3-module-%oname
%doc AUTHORS LICENSE *.rst
%_bindir/py.test3
%python3_sitelibdir/pytest.py
%python3_sitelibdir/_pytest/
%python3_sitelibdir/__pycache__/
%python3_sitelibdir/pytest-*.egg-info/

%files -n pytest3
%_bindir/pytest3

%changelog
