%define oname pytest-django

%def_with bootstrap
%def_disable check

Name: python-module-%oname
Version: 2.8.0
Release: alt3.1

Summary: A Django plugin for py.test
License: BSD
Group: Development/Python
Url: https://pypi.python.org/pypi/pytest-django/
# https://github.com/pytest-dev/pytest-django.git
BuildArch: noarch

Source: %name-%version.tar

BuildRequires: python-module-alabaster python-module-django python-module-docutils 
BuildRequires: python-module-html5lib python-module-objects.inv 
BuildRequires: python-module-pytest-xdist python-module-tox python-module-sphinx-devel

BuildRequires(pre): rpm-build-python3
%if_with bootstrap
BuildPreReq: python3-module-pytest-xdist
%endif
BuildPreReq: python3-module-django python3-module-tox


%description
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

%package -n python3-module-%oname
Summary: A Django plugin for py.test
Group: Development/Python3

%description -n python3-module-%oname
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
pytest-django allows you to test your Django project/applications with
the pytest testing tool.

This package contains documentation for %oname.

%prep
%setup

cp -fR . ../python3

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
%python_build_debug

pushd ../python3
%python3_build_debug
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%make -C docs pickle
%make -C docs html

install -d %buildroot%python_sitelibdir/%oname
cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

%check
export PYTHONPATH=$PWD
python setup.py test
py.test

pushd ../python3
export PYTHONPATH=$PWD
python3 setup.py test
py.test-%_python3_version
popd


%files
%doc AUTHORS *.rst
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files -n python3-module-%oname
%doc AUTHORS *.rst
%python3_sitelibdir/*


%changelog
