%define _unpackaged_files_terminate_build 1
%define oname pytest-pylint

%def_with check

Name: python-module-%oname
Version: 0.14.0
Release: alt1
Summary: pytest plugin to check source code with pylint
License: MIT
Group: Development/Python
BuildArch: noarch
Url: https://pypi.org/project/pytest-pylint/

# https://github.com/carsongee/pytest-pylint.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python-module-pytest-runner
BuildRequires: python3-module-pytest-runner

%if_with check
BuildRequires: pylint
BuildRequires: python-module-coverage
BuildRequires: python-module-mock
BuildRequires: python-module-pytest
BuildRequires: python-module-pytest-pep8
BuildRequires: python3-module-coverage
BuildRequires: python3-module-mock
BuildRequires: python3-module-pylint
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-pep8
BuildRequires: python3-module-tox
%endif

%description
Run pylint with pytest and have configurable rule types (i.e.
Convention, Warn, and Error) fail the build. You can also specify a
pylintrc file.

%package -n python3-module-%oname
Summary: pytest plugin to check source code with pylint
Group: Development/Python3

%description -n python3-module-%oname
Run pylint with pytest and have configurable rule types (i.e.
Convention, Warn, and Error) fail the build. You can also specify a
pylintrc file.

%prep
%setup

rm -rf ../python3
cp -fR . ../python3

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

%check
sed -i '/\[testenv\]/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    cp %_bindir\/coverage \{envbindir\}\/coverage\
    sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/coverage' tox.ini
export PIP_NO_INDEX=YES
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}
tox.py3 --sitepackages -p auto -o -v

%files
%doc *.rst pylintrc
%python_sitelibdir/pytest_pylint.py*
%python_sitelibdir/pytest_pylint-*.egg-info/

%files -n python3-module-%oname
%doc *.rst pylintrc
%python3_sitelibdir/pytest_pylint.py
%python3_sitelibdir/pytest_pylint-*.egg-info/
%python3_sitelibdir/__pycache__/

%changelog
