%define oname pyublas

%def_with python3

Name: python-module-%oname
Version: 2013.1
Release: alt1.git20140620.1.1.2
Summary: Seamless Numpy-UBlas interoperability
License: BSD
Group: Development/Python
Url: http://mathema.tician.de/software/pyublas
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# http://git.tiker.net/trees/pyublas.git
Source: %oname-%version.tar

BuildPreReq: boost-python-devel libnumpy-devel python-module-sphinx-devel
BuildPreReq: gcc-c++
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildPreReq: python3-devel libnumpy-py3-devel python3-module-setuptools
%endif

%description
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

%package -n python3-module-%oname
Summary: Seamless Numpy-UBlas interoperability
Group: Development/Python3

%description -n python3-module-%oname
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

%package -n python3-module-%oname-devel
Summary: Development files of PyUblas
Group: Development/Python3
Requires: python3-module-%oname = %version-%release

%description -n python3-module-%oname-devel
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains development files of PyUblas.

%package devel
Summary: Development files of PyUblas
Group: Development/Python
Requires: %name = %version-%release

%description devel
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains development files of PyUblas.

%package docs
Summary: Documentation for PyUblas
Group: Development/Documentation
BuildArch: noarch

%description docs
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains documentation for PyUblas.

%package pickles
Summary: Pickles for PyUblas
Group: Development/Python

%description pickles
PyUblas provides a seamless glue layer between Numpy and Boost.Ublas for
use with Boost.Python.

This package contains pickles for PyUblas.

%prep
%setup

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx .
ln -s ../objects.inv doc/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%make -C doc html

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
install -d %buildroot%_includedir
ln -s %python3_sitelibdir/pyublas/include/pyublas \
	%buildroot%_includedir/%oname-py3
popd
%endif

install -d %buildroot%_includedir
ln -s %python_sitelibdir/pyublas/include/pyublas %buildroot%_includedir/

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/

%pre devel
rm -fR %_includedir/pyublas

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/%oname/pickle
%exclude %python_sitelibdir/pyublas/include
%exclude %python_sitelibdir/pyublas/testhelp_ext.so

%files devel
%doc test/*
%_includedir/%oname
%python_sitelibdir/pyublas/include

%files docs
%doc doc/.build/html

%files pickles
%python_sitelibdir/%oname/pickle

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/pyublas/include
%exclude %python3_sitelibdir/pyublas/testhelp_ext.*.so

%files -n python3-module-%oname-devel
%doc test/*
%_includedir/%oname-py3
%python3_sitelibdir/pyublas/include
%endif

%changelog
