%define oname radssh

%def_with python3

Name: python-module-%oname
Version: 1.1.1
Release: alt1.1
Summary: RadSSH Module
License: BSD
Group: Development/Python
BuildArch: noarch
Url: https://pypi.python.org/pypi/radssh/

# https://github.com/radssh/radssh.git
Source: %name-%version.tar
Patch1: %oname-%version-alt-docs.patch

BuildRequires(pre): rpm-macros-sphinx
BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-paramiko python-module-netaddr
BuildRequires: python-module-alabaster python-module-docutils python-module-html5lib python-module-objects.inv
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-paramiko python3-module-netaddr
%endif

%py_provides %oname
%py_requires paramiko netaddr
%add_python_req_skip genders

%description
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

%if_with python3
%package -n python3-module-%oname
Summary: RadSSH Module
Group: Development/Python3
%py3_provides %oname
%py3_requires paramiko netaddr
%add_python3_req_skip genders

%description -n python3-module-%oname
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".
%endif

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
High level Paramiko-based toolkit, with an extensible parallel cluster
"shell".

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%if_with python3
cp -fR . ../python3
%endif

%prepare_sphinx docs
ln -s ../objects.inv docs/source/

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

export PYTHONPATH=$PWD
%make -C docs pickle
%make -C docs html

cp -fR docs/build/pickle %buildroot%python_sitelibdir/%oname/

%check
PYTHONPATH=%buildroot%python_sitelibdir python tests/dispatcher.py
%if_with python3
pushd ../python3
PYTHONPATH=%buildroot%python3_sitelibdir python3 tests/dispatcher.py
popd
%endif

%files
%doc README *.md api_sample
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/build/html/*

%if_with python3
%files -n python3-module-%oname
%doc README *.md api_sample
%python3_sitelibdir/*
%endif

%changelog
