%define _unpackaged_files_terminate_build 1
%define oname rlr

%def_with python3

Name: python-module-%oname
Version: 2.4.3
Release: alt1.1
Summary: Regularized Logistic Regression
License: MIT
Group: Development/Python
Url: https://pypi.python.org/pypi/rlr/

# https://github.com/datamade/rlr.git
Source: %oname-%version.tar

BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-Cython libnumpy-devel python-module-nose python-module-numpy-testing
BuildRequires: python-module-pylbfgs python2.7(future)
BuildRequires: python-module-html5lib python-module-notebook
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-Cython libnumpy-py3-devel python3-module-nose python3-module-numpy-testing
BuildRequires: python3-module-pylbfgs python3(future)
BuildRequires: python3-module-html5lib python3-module-notebook
%endif

%py_provides %oname
%py_requires numpy pylbfgs

%description
A Cython implementation of L2 regularized logistic regression.

%if_with python3
%package -n python3-module-%oname
Summary: Regularized Logistic Regression
Group: Development/Python3
%py3_provides %oname
%py3_requires numpy pylbfgs

%description -n python3-module-%oname
A Cython implementation of L2 regularized logistic regression.
%endif

%prep
%setup -n %oname-%version

%if_with python3
cp -fR . ../python3
%endif

%build
%python_build_debug

%if_with python3
pushd ../python3
%python3_build_debug
popd
%endif

%install
%python_install

%if_with python3
pushd ../python3
%python3_install
popd
%endif

%if "%_lib" == "lib64"
mv %buildroot%_libexecdir %buildroot%_libdir
%endif

%check
python setup.py build_ext -i
nosetests -v
%if_with python3
pushd ../python3
python3 setup.py build_ext -i
nosetests3 -v
popd
%endif

%files
%python_sitelibdir/*

%if_with python3
%files -n python3-module-%oname
%python3_sitelibdir/*
%endif

%changelog
