%define _unpackaged_files_terminate_build 1

%define oname shapely

%def_disable check

Name: python-module-%oname
Version: 1.7
Release: alt1.b1.p9.1

Summary: Planar geometries, predicates, and operations

License: BSD
Group: Development/Python
Url: http://pypi.python.org/pypi/Shapely

# https://github.com/Toblerity/Shapely.git
Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: libgeos-devel
BuildRequires: python-devel python-module-setuptools
BuildRequires: python-module-Cython libnumpy-devel
BuildRequires: python-module-descartes python-module-sphinx-devel
BuildRequires: python-module-matplotlib-sphinxext
BuildRequires: python-module-packaging
BuildRequires: python-module-pytest
BuildRequires: python-module-numpy-testing
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-Cython libnumpy-py3-devel
BuildRequires: python3-module-descartes
BuildRequires: python3-module-packaging
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: xvfb-run

%description
Planar geometries, predicates, and operations.

%package examples
Summary: Examples for %oname
Group: Development/Python
Requires: %name = %EVR

%description examples
Planar geometries, predicates, and operations.

This package contains examples for %oname.

%package -n python3-module-%oname
Summary: Planar geometries, predicates, and operations
Group: Development/Python3

%description -n python3-module-%oname
Planar geometries, predicates, and operations.

%package -n python3-module-%oname-examples
Summary: Examples for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-examples
Planar geometries, predicates, and operations.

This package contains examples for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python
%add_python_req_skip figures

%description pickles
Planar geometries, predicates, and operations.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Planar geometries, predicates, and operations.

This package contains documentation for %oname.

%prep
%setup
cp -fR . ../python3

%prepare_sphinx .
ln -s ../objects.inv docs/

%build
export LC_ALL=en_US.UTF-8
%add_optflags -fno-strict-aliasing

%python_build_debug

pushd ../python3
%python3_build_debug
popd

%install
export LC_ALL=en_US.UTF-8

%python_install

pushd ../python3
%python3_install
popd

%make -C docs pickle
%make -C docs html

cp -fR docs/_build/pickle %buildroot%python_sitelibdir/%oname/

# Tests fail on i586 due to fp math precision
%ifnarch %ix86
%check
export LC_ALL=en_US.UTF-8

python setup.py test
python setup.py build_ext -i
py.test -vv

pushd ../python3
xvfb-run python3 setup.py test
python3 setup.py build_ext -i
py.test3 -vv
popd
%endif

%files
%python_sitelibdir/*
%exclude %python_sitelibdir/*/pickle
%exclude %python_sitelibdir/*/examples

%files examples
%python_sitelibdir/*/examples

%files pickles
%python_sitelibdir/*/pickle

%files docs
%doc docs/_build/html/*

%files -n python3-module-%oname
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/examples

%files -n python3-module-%oname-examples
%python3_sitelibdir/*/examples

%changelog
