%define _unpackaged_files_terminate_build 1

%def_without python
%def_with python3
%define mname slip

Name: python-module-slip
Version: 0.6.5
Release: alt2
Summary: Miscellaneous convenience, extension and workaround code for Python

Group: Development/Python
License: %gpl2plus
Url: https://github.com/nphilipp/python-slip

Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-licenses

%if_with python
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
%endif

%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif

%description
The Simple Library for Python packages contain miscellaneous code for
convenience, extension and workaround purposes.

This package provides the "slip" and the "slip.util" modules.

%package dbus
Summary: Convenience functions for dbus services
Group: Development/Python
Requires: %name = %version-%release

%description dbus
The Simple Library for Python packages contain miscellaneous code for
convenience, extension and workaround purposes.

This package provides slip.dbus.service.Object, which is a dbus.service.Object
derivative that ends itself after a certain time without being used and/or if
there are no clients anymore on the message bus, as well as convenience
functions and decorators for integrating a dbus service with PolicyKit.

%package gtk
Summary: Code to make auto-wrapping gtk labels
Group: Development/Python

%description gtk
The Simple Library for Python packages contain miscellaneous code for
convenience, extension and workaround purposes.

This package provides slip.gtk.set_autowrap(), a convenience function which
lets gtk labels be automatically re-wrapped upon resizing.

# No python3-slip-gtk because there is no pygtk2 for Python 3.x

%if_with python3
%package -n python3-module-%mname
Summary: Miscellaneous convenience, extension and workaround code for Python 3.x
Group: Development/Python3

%description -n python3-module-%mname
The Simple Library for Python 3.x packages contain miscellaneous code for
convenience, extension and workaround purposes.

This package provides the "slip" and the "slip.util" modules.

%package -n python3-module-%mname-dbus
Summary: Convenience functions for dbus services
Group: Development/Python3
Requires: python3-module-%mname = %version-%release

%description -n python3-module-%mname-dbus
The Simple Library for Python 3.x packages contain miscellaneous code for
convenience, extension and workaround purposes.

This package provides slip.dbus.service.Object, which is a dbus.service.Object
derivative that ends itself after a certain time without being used and/or if
there are no clients anymore on the message bus, as well as convenience
functions and decorators for integrating a dbus service with PolicyKit.
%endif

%prep
%setup
%if_with python3
rm -rf ../python3
cp -a . ../python3
find ../python3 -name '*.py' -o -name '*.py.in' | xargs sed -i '1s|^#!/usr/bin/python|#!/usr/bin/python3|'
%endif

%build
%if_with python
%make_build PYTHON=/usr/bin/python
%endif

%if_with python3
pushd ../python3
%make_build PYTHON=/usr/bin/python3
popd
%endif

%install
%if_with python
%makeinstall_std PYTHON=/usr/bin/python
%endif

%if_with python3
pushd ../python3
%makeinstall_std PYTHON=/usr/bin/python3
popd
%endif

%if_with python
%files
%dir %python_sitelibdir/slip/
%python_sitelibdir/slip/__init__.py*
%python_sitelibdir/slip/util
%python_sitelibdir/slip/_wrappers
%python_sitelibdir/slip-%version-py%_python_version.egg-info

%files dbus
%doc doc/dbus
%python_sitelibdir/slip/dbus
%python_sitelibdir/slip.dbus-%version-py%_python_version.egg-info

%files gtk
%python_sitelibdir/slip/gtk
%python_sitelibdir/slip.gtk-%version-py%_python_version.egg-info
%endif

%if_with python3
%files -n python3-module-%mname
%dir %python3_sitelibdir/slip/
%python3_sitelibdir/slip/__init__.py*
%python3_sitelibdir/slip/util
%python3_sitelibdir/slip/_wrappers
%python3_sitelibdir/slip/__pycache__
%python3_sitelibdir/slip-%version-py%_python3_version.egg-info

%files -n python3-module-%mname-dbus
%doc doc/dbus
%python3_sitelibdir/slip/dbus
%python3_sitelibdir/slip.dbus-%version-py%_python3_version.egg-info
%endif

%changelog
