%define _unpackaged_files_terminate_build 1

%define oname sphinx
%define sphinx_dir %python_sitelibdir_noarch/%oname

Name: python-module-%oname
Epoch: 1
Version: 1.6.5
Release: alt8

Summary: Tool for producing documentation for Python projects
License: BSD
Group: Development/Python
Url: http://sphinx-doc.org

BuildArch: noarch

%py_requires simplejson
%py_requires alabaster
%py_requires requests
%py_requires typing
%py_requires sphinxcontrib.websupport
%py_requires docutils

Provides: python-module-objects.inv
Obsoletes: python-module-objects.inv

# https://github.com/sphinx-doc/sphinx.git
Source0: %name-%version.tar
Source1: conf.py.template
Source2: macro
Source4: refcounting.py

Patch0: sphinx-1.4b1-alt-avoid-download-objects.inv.patch 
# deprecate formatargspec() and format_annotation()
Patch1: 464f94c2380b4cb2600735c0c0085e771da2bce4.patch
Patch2: sphinx-1.6.5-Fix-sphinx.testing-uses-deprecated-pytest-API-Node.patch
Patch3: sphinx-1.6.4-alt-disable-remote-tests.patch

BuildRequires(pre): rpm-build-python
BuildRequires: python-sphinx-objects.inv
BuildRequires: python-module-docutils
BuildRequires: python-module-html5lib
BuildRequires: python-module-nose
BuildRequires: python-module-alabaster
BuildRequires: python2.7(typing)
BuildRequires: python2.7(sphinxcontrib.websupport)
BuildRequires: /usr/bin/convert
BuildRequires: python2.7(sphinxcontrib)
BuildRequires: %py_dependencies imagesize
# For %%check:
BuildRequires: %py_dependencies mock
BuildRequires: python2.7(pytest)
# minimal deps on the built-in sqlite driver have been fixed in 1.0.8-alt2:
BuildRequires: python-module-SQLAlchemy >= 1.0.8-alt2
# These 2 must be recent to pass the tests:
BuildRequires: python-module-Pygments >= 2.1.3
BuildRequires: python-module-alabaster >= 0.7.6-alt2.git20150703

%description
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%package devel
Summary: Development package for Sphinx
Group: Development/Python
Requires: %name = %EVR
Requires: %name-pickles = %EVR
Requires: rpm-macros-sphinx = %EVR

%description devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package -n rpm-macros-sphinx
Summary: RPM macros for build with Sphinx
Group: Development/Python

# W.r.t. to the content of the macros (see the substitution in %%install):
#Requires: %sphinx_dir
# ...but we do not add such a formal dependency,
# because it is not needed at all
# given the intended usage of rpm-macros-* packages.
# The guarantee that a macro doesn't refer to a path other
# than the current valid %%sphinx_dir
# is given by the strict dep of the main pkg (on EVR of the macros pkg).

%description -n rpm-macros-sphinx
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.

%package tests
Summary: Tests for Sphinx
Group: Development/Python
Requires: %name = %EVR
%py_requires nose
%add_python_req_skip compiler
%add_python_req_skip missing_module missing_package1 missing_package2
%add_python_req_skip dummy missing_package3
%add_findreq_skiplist %sphinx_dir/tests/typing_test_data.py

%description tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%package doc
Summary: Documentation for Sphinx
Group: Development/Python
%add_findreq_skiplist %sphinx_dir/pickle/_downloads/example_google.py
%add_findreq_skiplist %sphinx_dir/pickle/_downloads/example_numpy.py

%description doc
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package contains documentation for Sphinx itself.

%package pickles
Summary: Pickles for Sphinx
Group: Development/Python

%description pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
install -pm644 %SOURCE1 .

ln -s %_datadir/python-sphinx/objects.inv doc/
ln -s %_datadir/python-sphinx/objects.inv tests/

cp %SOURCE4 sphinx/ext/

install -pm644 %SOURCE2 .
# Invalid Python2:
rm tests/py35/test_autodoc_py35.py

%build
%python_build

# docs
%make_build -C doc html
%make_build -C doc man

%install
%python_install

ln -rs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx_dir/

# docs
install -d %buildroot%_docdir/%name
install -d %buildroot%_man1dir
cp -R doc/_build/html %buildroot%_docdir/%name/
install -p -m644 AUTHORS CHANGES* EXAMPLES LICENSE README.rst \
	%buildroot%_docdir/%name

# macros
install -d %buildroot%_rpmmacrosdir
sed -e 's:@SPHINX_DIR@:%sphinx_dir:g' < macro > %buildroot%_rpmmacrosdir/sphinx

# add pickle files
%make_build -C doc pickle

install -d %buildroot%sphinx_dir/doctrees
install -p -m644 doc/_build/doctrees/*.pickle \
	%buildroot%sphinx_dir/doctrees/
cp -R doc/_build/pickle %buildroot%sphinx_dir/
install -p -m644 conf.py.template \
	%buildroot%sphinx_dir/

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/%name-files.req.list
%sphinx_dir	%name
EOF

%check
# Tried to export NOSE_PROCESSES=%%__nprocs, but it makes a lot tests fail.
export LC_ALL=en_US.utf8 # some tests fail otherwise, because they use paths with Unicode

rm -f tests/test_build_linkcheck.py
PYTHONPATH=$(pwd) %make_build test

%files
%_bindir/*
%sphinx_dir/
%exclude %sphinx_dir/testing
%exclude %sphinx_dir/pickle
%exclude %sphinx_dir/doctrees
%python_sitelibdir/*.egg-info

%files devel

%files pickles
%sphinx_dir/pickle
%sphinx_dir/doctrees

%files tests
%sphinx_dir/testing

%files doc
%doc %_docdir/%name

%files -n rpm-macros-sphinx
%_rpmmacrosdir/sphinx
%_rpmlibdir/%name-files.req.list

%changelog
