%define oname stevedore

%def_disable check

Name: python-module-%oname
Version: 1.29.0
Release: alt2
Summary: Manage dynamic plugins for Python applications
Group: Development/Python
License: ASL 2.0
URL: http://docs.openstack.org/developer/stevedore/
Source: https://tarballs.openstack.org/%oname/%oname-%version.tar.gz
BuildArch: noarch

BuildRequires(pre): rpm-macros-sphinx

BuildRequires: python-devel
BuildRequires: python-module-setuptools
BuildRequires: python-module-pbr >= 2.0.0 python-module-six >= 1.10
BuildRequires: python-module-Pillow python-module-oslotest
BuildRequires: python-module-discover python-module-testrepository
BuildRequires: python-module-coverage python-module-mock
BuildRequires: python-module-mox3 python-module-mimeparse
BuildRequires: python-module-sphinx-devel
BuildRequires: python-module-openstackdocstheme >= 1.18.1
BuildRequires: python-module-reno >= 2.5.0

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-pbr >= 2.0.0 python3-module-six >= 1.10
BuildRequires: python3-module-Pillow python3-module-oslotest
BuildRequires: python3-module-discover python3-module-testrepository
BuildRequires: python3-module-coverage python3-module-mock
BuildRequires: python3-module-mox3 python3-module-mimeparse
BuildRequires: python3-module-sphinx-devel
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
BuildRequires: python3-module-reno >= 2.5.0

%py_provides %oname

%description
Manage dynamic plugins for Python applications

%package tests
Summary: Tests for %oname
Group: Development/Python
Requires: %name = %EVR

%description tests
Manage dynamic plugins for Python applications

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python

%description pickles
Manage dynamic plugins for Python applications

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
Manage dynamic plugins for Python applications

This package contains documentation for %oname.

%package -n python3-module-%oname
Summary: Manage dynamic plugins for Python applications
Group: Development/Python3
%py3_provides %oname

%description -n python3-module-%oname
Manage dynamic plugins for Python applications

%package -n python3-module-%oname-tests
Summary: Tests for %oname
Group: Development/Python3
Requires: python3-module-%oname = %EVR

%description -n python3-module-%oname-tests
Manage dynamic plugins for Python applications

This package contains tests for %oname.

%prep
%setup -n %oname-%version

cp -fR . ../python3

%prepare_sphinx doc
ln -s ../objects.inv doc/source/

%build
%python_build

pushd ../python3
%python3_build
popd

%install
%python_install

pushd ../python3
%python3_install
popd

export PYTHONPATH=$PWD
%make -C doc pickle
%make -C doc html

cp -fR doc/build/pickle %buildroot%python_sitelibdir/%oname/

%check
python setup.py test
rm -fR build
export PYTHONPATH=$PWD
py.test

pushd ../python3
python3 setup.py test
rm -fR build
export PYTHONPATH=$PWD
py.test-%_python3_version
popd


%files
%doc README.rst LICENSE
%python_sitelibdir/%oname
%python_sitelibdir/*.egg-info
%exclude %python_sitelibdir/%oname/pickle
%exclude %python_sitelibdir/%oname/tests
%exclude %python_sitelibdir/%oname/example

%files tests
%python_sitelibdir/%oname/tests
%python_sitelibdir/%oname/example

%files pickles
%python_sitelibdir/%oname/pickle

%files docs
%doc doc/build/html/*


%files -n python3-module-%oname
%doc README.rst LICENSE
%python3_sitelibdir/%oname
%python3_sitelibdir/*.egg-info
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/example

%files -n python3-module-%oname-tests
%python3_sitelibdir/%oname/tests
%python3_sitelibdir/%oname/example


%changelog
