%define _unpackaged_files_terminate_build 1
%define oname tox

%def_with check

Name: python-module-%oname
Version: 3.10.0
Release: alt1

Summary: virtualenv-based automation of test activities
License: MIT
Group: Development/Python
# Source-git: https://github.com/tox-dev/tox.git
Url: https://pypi.python.org/pypi/tox/

Source: %name-%version.tar
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-build-python3

BuildRequires: python-module-setuptools_scm
BuildRequires: python3-module-setuptools_scm

%if_with check
BuildRequires: /proc
BuildRequires: python2.7(flaky)
BuildRequires: python2.7(freezegun)
BuildRequires: python2.7(pathlib2)
BuildRequires: python2.7(pip)
BuildRequires: python2.7(psutil)
BuildRequires: python2.7(pytest_mock)
BuildRequires: python2.7(pytest_cov)
BuildRequires: python2.7(pytest_randomly)
BuildRequires: python2.7(pytest-xdist)
BuildRequires: python2.7(virtualenv)
BuildRequires: python2.7(six)
BuildRequires: python2.7(toml)
BuildRequires: python2.7(filelock)
BuildRequires: python3(flaky)
BuildRequires: python3(freezegun)
BuildRequires: python3(pathlib2)
BuildRequires: python3(pip)
BuildRequires: python3(psutil)
BuildRequires: python3(pytest_mock)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(pytest_randomly)
BuildRequires: python3(pytest-xdist)
BuildRequires: python3(virtualenv)
BuildRequires: python3(six)
BuildRequires: python3(toml)
BuildRequires: python3(filelock)
%endif

BuildArch: noarch
%py_requires virtualenv

%description
Tox as is a generic virtualenv management and test command line tool you
can use for:

* checking your package installs correctly with different Python
  versions and interpreters
* running your tests in each of the environments, configuring your test
  tool of choice
* acting as a frontend to Continuous Integration servers, greatly
  reducing boilerplate and merging CI and shell-based testing.

%package -n python3-module-%oname
Summary: virtualenv-based automation of test activities
Group: Development/Python3
%py3_requires virtualenv

%description -n python3-module-%oname
Tox as is a generic virtualenv management and test command line tool you
can use for:

* checking your package installs correctly with different Python
  versions and interpreters
* running your tests in each of the environments, configuring your test
  tool of choice
* acting as a frontend to Continuous Integration servers, greatly
  reducing boilerplate and merging CI and shell-based testing.

%prep
%setup
%patch -p1

# unpin deps
grep -qsF 'psutil >= 5.6.1' setup.cfg || exit 1
sed -i 's/psutil >= 5.6.1, < 6;/psutil;/g' setup.cfg
grep -qsF 'pip == 19.0.3' tox.ini || exit 1
sed -i 's/pip == 19.0.3/pip >= 19.0.3/g' tox.ini

cp -a . ../python3

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python_build

pushd ../python3
%python3_build
popd

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
        mv $i $i.py3
done
popd

%python_install

%check
# due to https://github.com/pypa/setuptools/issues/1702
export LANG=C.UTF-8

sed -i '/\[testenv\][[:space:]]*$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/py.test \{envbindir\}\/pytest\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/pytest' tox.ini
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
export PIP_NO_INDEX=YES
export PIP_FIND_LINKS=%python_sitelibdir_noarch/virtualenv_support
export TOX_TESTENV_PASSENV='SETUPTOOLS_SCM_PRETEND_VERSION PIP_NO_INDEX \
PIP_FIND_LINKS'
export TOXENV=py%{python_version_nodots python},py%{python_version_nodots python3}

export PYTHONPATH=%buildroot%python_sitelibdir_noarch
%buildroot%_bindir/tox --sitepackages -p auto -o -rv -- -m "not internet"

pushd ../python3
sed -i '/\[testenv\][[:space:]]*$/a whitelist_externals =\
    \/bin\/cp\
    \/bin\/sed\
commands_pre =\
    \/bin\/cp %_bindir\/py.test3 \{envbindir\}\/pytest\
    \/bin\/sed -i \x271c #!\{envpython\}\x27 \{envbindir\}\/pytest' tox.ini

export PYTHONPATH=%buildroot%python3_sitelibdir_noarch
%buildroot%_bindir/tox.py3 --sitepackages -p auto -o -rv -- -m "not internet"
popd

%files
%_bindir/tox
%_bindir/tox-quickstart
%python_sitelibdir/tox/
%python_sitelibdir/tox-*.egg-info/

%files -n python3-module-%oname
%_bindir/tox.py3
%_bindir/tox-quickstart.py3
%python3_sitelibdir/tox/
%python3_sitelibdir/tox-*.egg-info/

%changelog
