%define oldname python-ttystatus
%global pkgname ttystatus

Name: python-module-ttystatus
Version: 0.34
Release: alt1

Summary: Progress and status updates on terminals for Python

License: GPLv3+
Group: Development/Python
Url: http://liw.fi/%pkgname/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://code.liw.fi/debian/pool/main/p/%oldname/%{oldname}_%version.orig.tar.gz
Source44: import.info

BuildArch: noarch

# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python
BuildRequires: python-devel
# END SourceDeps(oneline)

#BuildRequires: python-module-coverage-test-runner
BuildRequires: python-module-sphinx python-module-alabaster

%description
ttystatus is a Python library for showing progress reporting and
status updates on terminals, for (Unix) command line programs. Output
is automatically adapted to the width of the terminal: truncated if it
does not fit, and re-sized if the terminal size changes.

Output is provided via widgets. Each widgets formats some data into a
suitable form for output. It gets the data either via its initializer,
or from key/value pairs maintained by the master object. The values
are set by the user. Every time a value is updated, widgets get
updated (although the terminal is only updated every so often to give
user time to actually read the output).

%package -n python-module-ttystatus-doc
Group: Other
Summary: Documentation for %pkgname

%description -n python-module-ttystatus-doc
This package contains the documentation for %pkgname, a Python
library providing progress and status updates on terminals.

%prep
%setup -n %pkgname-%version

%build
%python_build
# Build documentation
make

%install
%python_install

%check
exit 0
# CoverageTestRunner trips up on build directory;
# since we've already done the install phase, remove it first
rm -rf build
make check

%files
%doc COPYING NEWS README
%python_sitelibdir_noarch/*

%files -n python-module-ttystatus-doc
%doc doc/_build/html/*

%changelog
